Extension { #name : 'IndexingErrorPreventingCommit' }

{ #category : 'Private' }
IndexingErrorPreventingCommit class >> resignal: anException objWithIndex: anObject [
  " check for recursive signal "

  (anException isKindOf: IndexingErrorPreventingCommit)
    ifTrue: [
      | mgr |
      (mgr := IndexManager) current autoCommit
        ifTrue: [
          anObject
            ifNotNil: [ anObject removeIncompleteIndex ]
            ifNil: [ mgr removeAllIncompleteIndexes ] ].
      anException pass ]
    ifFalse: [
      | epcEx |
      (epcEx := IndexingErrorPreventingCommit new) args: {anException}.
      epcEx messageText: anException description.
      epcEx _preventCommits.
      anException resignalAs: epcEx ]

]

{ #category : 'Private' }
IndexingErrorPreventingCommit >> _preventCommits [
  | details |
  (details := gsDetails) ifNil:[
    details := 'anIndexingErrorPreventingCommit'.
    gsDetails := details.
  ].
  System disableCommitsUntilAbortWithReason: details .

]

{ #category : 'Private' }
IndexingErrorPreventingCommit >> _signal [

  self _preventCommits .
  ^ super _signal

]

{ #category : 'Instance initialization' }
IndexingErrorPreventingCommit >> initialize [
  gsNumber := ERR_IndexingErrorPreventingCommit.
  gsResumable := true .
  gsTrappable := true .

]
