Extension { #name : 'Magnitude' }

{ #category : 'Indexing Support' }
Magnitude class >> _idxCanOptimizeComparison [
  "Answer true if it is possible to optimize index-related comparisons by replacing
   _idxForCompare* calles with a primitive comparison call instead.

     _idxForCompareEqualTo:              #=
     _idxForCompareGreaterThan:          #>
     _idxForCompareGreaterThanOrEqualTo: #>=
     _idxForCompareLessThan:             #<
     _idxForCompareLessThanOrEqualTo:    #<=
     _idxForCompareNotEqualTo:           #~=
   "

  "In general all subclasses of Magnitude can optimize comparisons."

  ^ true

]

{ #category : 'Instance Creation' }
Magnitude class >> fromStream: aStream [

"(Subclass responsibility.)  Returns an instance of the receiver."

Magnitude subclassResponsibility: #fromStream:

]

{ #category : 'Instance Creation' }
Magnitude class >> fromString: aString [

"Returns an instance of the appropriate subclass, reconstructed from aString.
 The String must contain only Characters representing the object to be created,
 although leading and trailing blanks are permitted."

| s result |

s := ReadStreamPortable on: aString.
result := self fromStream: s.
[ s atEnd ]
whileFalse:
  [ (s next == $  )
    ifFalse:
      [ self _errIncorrectFormat: aString ]
  ].
^ result

]

{ #category : 'Private' }
Magnitude >> _deepCopyWith: copiedObjDict [

"Private. Used internally to implement deepCopy."

| copy |

self isSpecial ifTrue: [ ^ self ].

copy := copiedObjDict at: self otherwise: nil.
copy ~~ nil ifTrue: [ ^ copy ].

copy := self copy.
copiedObjDict at: self put: copy.

^ copy.

]

{ #category : 'Indexing Support' }
Magnitude >> _idxOptimizedCompareWithClass: aClass [
  "Returns true if the receiver may be inserted into a BtreePlusNode whose
   #lastElementClass is <aClass> and whose comparisons are optimized."

  "Sent when index option optimizeComparison is true and aClass responds trut to #_idxCanOptimizeComparison"

  ^ true

]

{ #category : 'Comparing' }
Magnitude >> < aMagnitude [

"(Subclass responsibility.)  Returns true if the receiver is less than
 aMagnitude; returns false otherwise."

Magnitude subclassResponsibility: #<

]

{ #category : 'Comparing' }
Magnitude >> <= aMagnitude [

"Returns true if the receiver is less than or equal to aMagnitude;
 returns false otherwise."

^(self > aMagnitude) == false

]

{ #category : 'Comparing' }
Magnitude >> = aMagnitude [

"(Subclass responsibility.)  Returns true if the receiver is equal to
 aMagnitude; returns false otherwise."

Magnitude subclassResponsibility: #=

]

{ #category : 'Comparing' }
Magnitude >> > aMagnitude [

"Returns true if the receiver is greater than aMagnitude;
 returns false otherwise."

^ aMagnitude < self

]

{ #category : 'Comparing' }
Magnitude >> >= aMagnitude [

"Returns true if the receiver is greater than or equal to aMagnitude;
 returns false otherwise."

^(self < aMagnitude) == false

]

{ #category : 'Comparing' }
Magnitude >> between: min and: max [

"Returns true if the receiver is less than or equal to the argument max and
 greater than or equal to the argument min.  Returns false otherwise."

^ (self >= min) and:[ self <= max ]

]

{ #category : 'Comparing' }
Magnitude >> hash [

"(Subclass responsibility.)  Returns a numeric hash index."

"Two Numbers for which = is true, must have the same hash value."

Magnitude subclassResponsibility: #hash

]

{ #category : 'Comparing' }
Magnitude >> max: aMagnitude [

"If the receiver is greater than the argument, return the receiver.
 Otherwise return the argument."

self > aMagnitude
        ifTrue: [^self].
^aMagnitude

]

{ #category : 'Comparing' }
Magnitude >> min: aMagnitude [

"If the receiver is less than the argument, return the receiver.
Otherwise return the argument."

self < aMagnitude
        ifTrue: [^self].
^aMagnitude

]
