Extension { #name : 'QuadByteSymbol' }

{ #category : 'Instance Creation' }
QuadByteSymbol class >> _basicNew [
^ self shouldNotImplement: #_basicNew

]

{ #category : 'Instance Creation' }
QuadByteSymbol class >> _basicNew: aSize [
^ self shouldNotImplement: #_basicNew:

]

{ #category : 'Class Membership' }
QuadByteSymbol class >> _classHistoryIncludesIdentical: aClass [
  ^ aClass == Symbol or:[ aClass == DoubleByteSymbol or:[ aClass == QuadByteSymbol]]

]

{ #category : 'Instance Creation' }
QuadByteSymbol class >> _existingWithAll: aString [

"Returns an existing canonical symbol that has the same value as 'aString'.
 If no such Symbol, DoubleByteSymbol or QuadByteSymbol already exists, returns nil."

"This method is useful in processing Strings that are supposed to be names
 of already existing instance variables, such as in indexing and sorting."

<primitive: 310>
aString _validateClass: CharacterCollection .
^ self _existingWithAll: aString asString .

]

{ #category : 'Instance Creation' }
QuadByteSymbol class >> _newString [

"Returns a new instance of String."

^ QuadByteString new

]

{ #category : 'Instance Creation' }
QuadByteSymbol class >> _newString: aSize [

"Returns a new instance of String."

^ QuadByteString new: aSize

]

{ #category : 'Class Membership' }
QuadByteSymbol class >> isSubclassOf: aClassHistoryOrClass [

  (self _classHistoryIncludesIdentical: aClassHistoryOrClass) ifTrue:[ ^ true].
  ^ super isSubclassOf: aClassHistoryOrClass

]

{ #category : 'Storing and Loading' }
QuadByteSymbol class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| theSize str marker result |

"since Symbols can't refer to other objects, the 'hasRead:' message
 may be sent after values have been filled in."

theSize := passiveObj readSize .
str := String new .
marker := passiveObj objectPositionMarker .
passiveObj next: theSize bytesTo: str ;
           next .
result :=  (str _changeClassToMultiByte: QuadByteString) asSymbol .
passiveObj hasRead: result marker: marker .
^ result

]

{ #category : 'Instance Creation' }
QuadByteSymbol class >> migrateNew [

"Override default migrateNew behavior with #_basicNew."

^ self _basicNew

]

{ #category : 'Instance Creation' }
QuadByteSymbol class >> new [

"Disallowed."
self shouldNotImplement: #new

]

{ #category : 'Instance Creation' }
QuadByteSymbol class >> new: aSize [

"Disallowed."
self shouldNotImplement: #new:

]

{ #category : 'Instance Creation' }
QuadByteSymbol class >> withAll: aString [

"Returns a canonical symbol that has the same Characters as aString."

<primitive: 300>
^ Symbol withAll: aString

]

{ #category : 'Decompiling without Sources' }
QuadByteSymbol >> _asSource [

| result |
result := String new .
result add: $#  .
result addAll: super _asSource .
^ result

]

{ #category : 'New Indexing Comparison' }
QuadByteSymbol >> _idxForCompareEqualTo: arg [
  ""

  ^ arg _idxForCompareEqualToQuadByteSymbol: self

]

{ #category : 'New Indexing Comparison' }
QuadByteSymbol >> _idxForCompareEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ aCharacterCollection _idxForCompareEqualToQuadByteSymbol: self

]

{ #category : 'New Indexing Comparison - for Compare' }
QuadByteSymbol >> _idxForCompareEqualToCharacterCollection: aCharacterCollection [
  "second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:."

  ^ false

]

{ #category : 'New Indexing Comparison - for Compare' }
QuadByteSymbol >> _idxForCompareEqualToUnicode: aUnicodeString collator: aCollator [
"second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:collator:."

  ^ false

]

{ #category : 'New Indexing Comparison' }
QuadByteSymbol >> _idxForSortEqualTo: arg [
  ""

  ^ super _idxForSortEqualToSymbol: arg

]

{ #category : 'New Indexing Comparison' }
QuadByteSymbol >> _idxForSortEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ self asString
    _idxForSortEqualTo: aCharacterCollection
    collator: anIcuCollator

]

{ #category : 'New Indexing Comparison' }
QuadByteSymbol >> _idxForSortEqualToSymbol: aSymbol [
  "second half of a double dispatch call from Symbol>>_idxForSortEqualTo:."

  ^ self asString _idxPrimCompareEqualTo: aSymbol asString

]

{ #category : 'New Indexing Comparison' }
QuadByteSymbol >> _idxForSortNotEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ (self _idxForSortEqualTo: aCharacterCollection collator: anIcuCollator) not

]

{ #category : 'Converting' }
QuadByteSymbol >> -> anObject [

"Returns a SymbolAssociation with the receiver as the key and the given object
 as the value."

^ SymbolAssociation newWithKey: self value: anObject

]

{ #category : 'Concatenating' }
QuadByteSymbol >> , aCharOrCharCollection [

"Returns a new instance of DoubleByteString that contains the elements of
 the receiver followed by the elements of aCharOrCharCollection.
 A DoubleByteString is returned rather than a DoubleByteSymbol to avoid
 the expense of unnecessary creation and canonicalization of Symbols."

^ ((self _unicodeCompareEnabled ifTrue:[ Unicode32 ] ifFalse:[ QuadByteString])
    withAll: self) addAll: aCharOrCharCollection ; yourself

]

{ #category : 'Comparing' }
QuadByteSymbol >> = anObject [

"Returns true if anObject is equal to the receiver.  Since symbols
 are canonicalized, this method does the check based on the
 identities of the receiver and the argument."

^ self == anObject.

]

{ #category : 'Comparing' }
QuadByteSymbol >> ~= aCharCollection [

"This method can be optimized for symbols since they are canonical."

^ self ~~ aCharCollection

]

{ #category : 'Compatiblity' }
QuadByteSymbol >> argumentCount [

 ^ self numArgs

]

{ #category : 'Converting' }
QuadByteSymbol >> asString [

"Returns a copy of the receiver as a String."

^ String withAll: self.

]

{ #category : 'Converting' }
QuadByteSymbol >> asSymbol [

"Returns the receiver."

^ self

]

{ #category : 'Converting' }
QuadByteSymbol >> asSymbolKind [

"Returns the receiver.  "

^ self

]

{ #category : 'Clustering' }
QuadByteSymbol >> cluster [

"Has no effect.  Clustering of symbols is only performed by
 the clusterAllSymbols method in class System . "

^ true

]

{ #category : 'Clustering' }
QuadByteSymbol >> clusterInBucket: aClusterBucketOrId [

"Has no effect.  Clustering of symbols is only performed by
 the clusterAllSymbols method in class System . "

^ true

]

{ #category : 'Copying' }
QuadByteSymbol >> copy [

"Returns self.  Copies of (canonical) symbols are not allowed."

^ self

]

{ #category : 'Copying' }
QuadByteSymbol >> copyReplacing: oldObject withObject: newObject [
	"Returns a String comprising a copy of the receiver in which all occurrences
	 of objects equal to oldObject have been replaced by newObject."

	^self asQuadByteString copyReplacing: oldObject withObject: newObject

]

{ #category : 'Comparing' }
QuadByteSymbol >> hash [

"Returns a numeric hash key for the receiver.
 This implementation for new databases only and is
 replaced in the upgrade scripts."

^ self identityHash

]

{ #category : 'Converting' }
QuadByteSymbol >> keywords [

"Returns an Array of the keywords in the receiver, treating
 any colon-delimited segment as if it was a legal keyword."

^ Symbol _keywords: self

]

{ #category : 'Testing' }
QuadByteSymbol >> precedence [

"Returns the precedence of the receiver, were it a message selector, with
 1=unary, 2=binary and 3=keyword."

^self isInfix
    ifTrue: [ 2 ]
    ifFalse: [ self isKeyword ifTrue: [ 3 ]
                              ifFalse: [ 1 ] ]

]

{ #category : 'Formatting' }
QuadByteSymbol >> printOn: aStream [

"Puts a displayable representation of the receiver on the given stream.
 That representation conforms to GemStone Smalltalk parsing rules."

aStream nextPut: $# .
super printOn: aStream

]

{ #category : 'Copying' }
QuadByteSymbol >> shallowCopy [

"Returns self.  Copies of symbols are not allowed."

^ self

]

{ #category : 'Class Membership' }
QuadByteSymbol >> species [
  "(R) Returns a class similar to, or the same as, the receiver's class which
   can be used for containing derived copies of the receiver."

  ^ QuadByteString

]

{ #category : 'Private' }
QuadByteSymbol >> speciesForConversion [

^ QuadByteString .

]

{ #category : 'Formatting' }
QuadByteSymbol >> withNoColons [

"Returns a String containing the value of the receiver with all colons removed.

 A String is returned rather than a symbol to avoid the expense of unnecessary
 creation and canonicalization of symbols."

^ self copyWithout: $:   .

]
