Extension { #name : 'SelectBlock' }

{ #category : 'Accessing' }
SelectBlock >> argumentCount [
	"A SelectBlock can only take one argument."

	^self queryBlock argumentCount.

]

{ #category : 'Block Evaluation' }
SelectBlock >> ensure: aBlock [
	"Evaluate the receiver.
	 Evaluate aBlock after evaluating the receiver,
	 or before any return from a block that would return to the sender.
	 Returns result of evaluating the receiver.

	 aBlock must be a zero-arg instance of ExecBlock, otherwise an error is generated. "

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #ensure:.

]

{ #category : 'Block Evaluation' }
SelectBlock >> ifCurtailed: terminationBlock [
	"Evaluate the receiver and return its result. If abnormal termination of the receiver occurs,
	 terminationBlock is evaluated. The value returned from the evaluation of
	 terminationBlock is discarded."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #ifCurtailed:.

]

{ #category : 'Accessing' }
SelectBlock >> iterationBlock [

"Returns the value of the iterationBlock instance variable."

^iterationBlock

]

{ #category : 'Block Evaluation' }
SelectBlock >> on: exceptionSelector do: handlerBlock [
	"Try to evaluate the receiver, which should be a zero-argument block.
	 If an exception occurs and the expression exceptionSelector handles: theExceptionInstance
	 returns true, then evaluate the one argument block handlerBlock, passing it the exception
	 instance as its argument.

	 These forms are supported directly by the VM
		(1) on: anException do: handlerBlock
		(2) on: anExceptionSet do: handlerBlock
	 This form is handled by Smalltalk code in the body of this method.
		(3) on: anObject do: handlerBlock

	 anException must be the class Exception  or a subclass thereof;
	 anExceptionSet must be a kind of ExceptionSet;
	 handlerBlock must be an instance of ExecBloc otherwise an error is generated.

	 For forms 1, 2, and 3 if handlerBlock is not a one argument block,
	 an error is generated if exception handling attempts to invoke that handlerBlock.

	 If handlerBlock is invoked to handle an Exception which occurs during execution of the
	 receiver and handlerBlock completes normally , then the result of handlerBlock (the value
	 of the last expression in handlerBlock) will be the result of the on:do: send .  Other-than-normal
	 completion of handlerBlock is available by use of Exception's instance methods such as
	 #return, #return:, #retry, #retryUsing:, #resume, #resume:, #pass, and #outer within handlerBlock.

	 For forms 1 and 2, when searching for a handlerBlock to handle a signaled Exception, the VM
	 uses Behavior>>_subclassOf: semantics . classHistories of the class of the signaled Exception
	 and of anException or elements of anExceptionSet are ignored."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #on:do:.

]

{ #category : 'Accessing' }
SelectBlock >> queryBlock [

"Returns the value of the queryBlock instance variable."

^queryBlock

]

{ #category : 'Block Evaluation' }
SelectBlock >> value [
	"Return the value of the receiver evaluated with no arguments.
	 If the receiver expects any arguments, signal an error."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #value.

]

{ #category : 'Block Evaluation' }
SelectBlock >> value: anObject [

"Returns the value of the receiver evaluated with anObject as its
 argument.  A SelectBlock can only take one argument."

^iterationBlock value: anObject

]

{ #category : 'Block Evaluation' }
SelectBlock >> value: firstObject value: secondObject [
	"Return the value of the receiver evaluated with the specified arguments.  If
	 the receiver expects a different number of arguments, signal an error."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #value:value:.

]

{ #category : 'Block Evaluation' }
SelectBlock >> valueWithArguments: argList [
	"Return the value of the receiver evaluated with the specified arguments.  If
	 the receiver expects a different number of arguments, signal an error."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #valueWithArguments:.

]

{ #category : 'Flow of Control' }
SelectBlock >> whileFalse [
	"Evaluate the receiver once and then repeatedly as long as the value
	 returned by the evaluation is false."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #whileFalse.

]

{ #category : 'Flow of Control' }
SelectBlock >> whileFalse: aBlock [
	"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
	 while the receiver evaluates to false.  Return nil.  Generates an error if the
	 receiver is not a zero-argument block."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #whileFalse:.

]

{ #category : 'Flow of Control' }
SelectBlock >> whileTrue [
	"Evaluate the receiver once and then repeatedly as long as the value
	 returned by the evaluation is true."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #whileTrue.

]

{ #category : 'Flow of Control' }
SelectBlock >> whileTrue: aBlock [
	"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
	 while the receiver evaluates to true.  Return nil.  Generates an error if the
	 receiver is not a zero-argument block."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #whileTrue:.

]

{ #category : 'Flow of Control' }
SelectBlock >> doWhileFalse: conditionBlock [
   "this selector does not apply to SelectBlocks"
   ^self shouldNotImplement:  #doWhileFalse:
]

{ #category : 'Flow of Control' }
SelectBlock >> untilFalse [
	^self shouldNotImplement: #untilFalse .
]

{ #category : 'Flow of Control' }
SelectBlock >> untilFalse: aBlock [
	^self shouldNotImplement: #untilFalse: .
]

