Extension { #name : 'SmallFraction' }

{ #category : 'Storing and Loading' }
SmallFraction class >> loadFrom: passiveObj [
  | n d inst |
  passiveObj readNamedIV.
  n := passiveObj ivValue.
  n  _isSmallInteger ifFalse:[ Error signal:'unexpected ', n class name ].
  passiveObj readNamedIV.
  d := passiveObj ivValue.
  d  _isSmallInteger ifFalse:[ Error signal:'unexpected ', d class name ].
  passiveObj skipNamedInstVars.

  inst := self numerator: n denominator: d .
  inst class == SmallFraction ifFalse:[ Error signal:'unexpected ', inst class name ].
  ^ inst
]

{ #category : 'Storing and Loading' }
SmallFraction >> containsIdentity [
  ^ true

]

{ #category : 'Accessing' }
SmallFraction >> denominator [
<primitive: 1000>

^ self _primitiveFailed: #denominator

]

{ #category : 'Testing' }
SmallFraction >> isSpecial [
  ^ true

]

{ #category : 'Accessing' }
SmallFraction >> numerator [
<primitive: 999>

^ self _primitiveFailed: #numerator

]

{ #category : 'Storing and Loading' }
SmallFraction >> writeTo: passiveObj [
  "reimplement basicWriteTo: to synthesize output of numerator and denominator"
  passiveObj writeClass: self class ;
     writeObject: self numerator named: #numerator ;
     writeObject: self denominator named: #denominator ;
     endNamedInstVars ;
     cr .

]
