Extension { #name : 'SymbolKeyValueDictionary' }

{ #category : 'Accessing' }
SymbolKeyValueDictionary >> at: aKey ifAbsent: aBlock [
  | sym |
  aKey ifNotNil:[ sym := Symbol _existingWithAll: aKey ].
  sym ifNil:[
    aBlock ifNil:[^ self _errorKeyNotFound: aKey ] .
    ^ aBlock value
  ] ifNotNil:[
    ^ super at: sym ifAbsent: aBlock
  ]

]

{ #category : 'Accessing' }
SymbolKeyValueDictionary >> at: aKey otherwise: aValue [

  (Symbol _existingWithAll: aKey)
     ifNil:[ ^ aValue ]
     ifNotNil:[ :sym | ^ super at: sym otherwise: aValue ]

]

{ #category : 'Updating' }
SymbolKeyValueDictionary >> at: aKey put: aValue [

"Stores the aKey/aValue pair in the hash dictionary.
 aKey must be convertible to a Symbol.

 Rebuilds the hash table if the addition caused the number of collisions
 to exceed the limit allowed."

^ super at: (aKey asSymbol) put: aValue

]

{ #category : 'Accessing' }
SymbolKeyValueDictionary >> keys [

"Returns a SymbolSet containing the receiver's keys."

| result |
result := SymbolSet new .
self keysAndValuesDo:[ :aKey :aValue | result add: aKey ].
^ result

]

{ #category : 'Removing' }
SymbolKeyValueDictionary >> removeKey: aKey ifAbsent: aBlock [

  (Symbol _existingWithAll: aKey) ifNil:[
    aBlock ifNil:[^ self _errorKeyNotFound: aKey ] .
    ^ aBlock value
  ] ifNotNil:[ :sym |
    ^ super removeKey: sym ifAbsent: aBlock
  ]

]

{ #category : 'Removing' }
SymbolKeyValueDictionary >> removeKey: aKey otherwise: aValue [

  (Symbol _existingWithAll: aKey)
     ifNil:[ ^ aValue ]
     ifNotNil:[ :sym | ^ super removeKey: sym otherwise: aValue ]

]
