Extension { #name : 'SystemCallError' }

{ #category : 'Instance initialization' }
SystemCallError >> _legacyHandlerArgs [
  | arr |
  (arr := { errno } ) addAll: super _legacyHandlerArgs .
  ^ arr

]

{ #category : 'Instance initialization' }
SystemCallError >> args: anArray [
  anArray _isArray ifTrue:[ | sz |
    errno := anArray atOrNil: 1 .
    (sz := anArray size) > 1 ifTrue:[
      gsArgs := anArray copyFrom:2 to: sz
    ].
  ]

]

{ #category : 'Formatting' }
SystemCallError >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    errno ifNotNil:[:e| 
      (str := String withAll:'errno=') add: errno asString;
         add:' '; add: (AbstractException errnoToName: e) .
    ].
    gsDetails ifNotNil:[:d| str add:', '; add: d  asString ].
    GsFile gciLogServer:' SystemCallError >> asString : ', str asString .
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
SystemCallError >> errno: anInt [
  errno := anInt

]

{ #category : 'Instance initialization' }
SystemCallError >> initialize [
  gsNumber := ERR_SystemCallError.
  gsResumable := true .
  gsTrappable := true .

]
