Extension { #name : 'Behavior' }

{ #category : 'Private' }
Behavior >> _copyDictForQuery: aDictionary [
  | res |
  (System myUserProfile _hasPrivilegeBit: 12"CodeModification" ) ifTrue:[ 
     ^ aDictionary copy 
  ].
  res := IdentityKeyValueDictionary new.
  aDictionary keysAndValuesDo:[:k :v| res at: k put: v ].
  ^ res
]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> _fullMethodDictEnv: envId [

"Returns a dictionary of combined base and override methods.
 Does not include the transient method dictionary.
 For envId==0 only,  includes the GsPackagePolicy contents.
 Used by ClassOrganizer."
 | res |
 res := SymbolKeyValueDictionary new .
 (self persistentMethodDictForEnv: envId) ifNotNil:[ :aDict |
    aDict keysAndValuesDo:[:k :v | res at: k put: v ].
 ].
 envId == 0 ifTrue:[
   GsPackagePolicy currentOrNil ifNotNil:[:pp| pp copyMethodDictFor: self into: res ].
 ].
^ res

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> _fullMethodDictEnv0 [

^ self _fullMethodDictEnv: 0

]

{ #category : 'Private' }
Behavior >> _newMethodDictForQuery [
  "fix 50620"
  ^ ((System myUserProfile _hasPrivilegeBit: 12"CodeModification" ) 
      ifTrue:[ GsMethodDictionary] ifFalse:[ IdentityKeyValueDictionary ]) new

]

{ #category : 'Browser Methods' }
Behavior >> _selectorWithSource: aString [

"Returns the selector for the environment 0 method
 whose source string is identical to aString."

self _fullMethodDictEnv0 keysAndValuesDo:[:aSelector :aMethod |
  (aMethod _sourceString == aString) ifTrue: [^ aSelector ]
].
^nil

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> _topazMethodLookup: aString env: envId usePackages: usePkgBool [
  "Returns an Array   { actualSelector , class } "
  | sel |
  sel := aString .
  ^ { sel .
      self whichClassIncludesSelector: sel environmentId: envId
        usePackages: usePkgBool
    }

]

{ #category : 'Enumerating' }
Behavior >> _unifiedCategorys: envId [
  | cats |
  cats := self _baseCategorys: envId .
  cats ifNil:[ cats := self _newMethodDictForQuery ] ifNotNil:[ self _copyDictForQuery: cats ].
  envId == 0 ifTrue:[
    cats := cats ifNil:[ self _newMethodDictForQuery ] ifNotNil:[ cats copy ].
    GsPackagePolicy currentOrNil ifNotNil:[:pp| pp copyCategoryDictFor: self into: cats ].
  ].
  ^ cats

]

{ #category : 'Category' }
Behavior >> category [

"Returns the classCategory instance variable of the receiver.  If the receiver's
 category is nil, returns its superclass's category."

| categ supercls |
categ := self _classCategory .
supercls := self superClass .
categ ifNil: [
  supercls == Object ifTrue:[
    self objectSecurityPolicy == SystemObjectSecurityPolicy
      ifTrue:[  ^ 'Kernel' ]
      ifFalse:[ ^ 'User Classes' ].
  ].
  supercls == nil ifTrue: [ ^'Kernel' ].
  ^ supercls category
].
^ categ

]

{ #category : 'Browser Methods' }
Behavior >> compiledMethodAt: aSelector environmentId: envId otherwise: notFoundVal [
  ^ self compiledMethodAt: aSelector environmentId: envId otherwise: notFoundVal
         usePackages: false

]

{ #category : 'Browser Methods' }
Behavior >> compiledMethodAt: aSelector environmentId: envId otherwise: notFoundVal usePackages: usePkg [

"Returns the compiled method associated with the argument aSelector (a String).
 The argument must be a selector in the receiver's method dictionary; if it is
 not, this method returns notFoundVal.
 If usePkg is true, looks in GsPackagePolicy, then in persistent method dicts;
 else looks in session method dicts then in persistent method dicts"

  <primitive: 2001>  "enter protected mode"
  | prot |
  prot := System _protectedMode .
  ^ [ | aSym meth md |
      (aSym := Symbol _existingWithAll: aSelector) ifNotNil:[
	(envId == 0 and:[ usePkg]) ifTrue:[
	  meth := GsPackagePolicy currentOrNil ifNotNil:[:pp | pp compiledMethodAt: aSym for: self ].
	] ifFalse:[
	  (md := self transientMethodDictForEnv: envId) ifNotNil:[
	    meth := md at: aSym otherwise: notFoundVal .
	  ]
	].
	meth ifNil:[
	  (md := self persistentMethodDictForEnv: envId ) ifNotNil:[
	    meth := md at: aSym otherwise: notFoundVal .
	  ].
	].
      ].
      meth ifNil:[ notFoundVal]
    ] ensure:[
      prot _leaveProtectedMode
    ].

]

{ #category : 'Browser Methods' }
Behavior >> compiledMethodAt: aSelector environmentId: envId usePackages: usePkg [
| aMeth |
aMeth := self compiledMethodAt: aSelector environmentId: envId otherwise: nil
		usePackages: usePkg .
aMeth == nil ifTrue:[ self _error: #rtErrKeyNotFound args: { aSelector } ].
^ aMeth

]

{ #category : 'Enumerating' }
Behavior >> env: envId categorysDo: aBlock [
  "evaluates aBlock for each method category of receiver
   in specified environment. Returns the receiver.

   aBlock should be a two argument block
   expecting the args  categoryNameSymbol ,   selectorsSet.
   If the package manager is active in the current session,
   aBlock may be invoked more than once for each category name.
   The iteration is done directly over the receiver's categories."

  envId == 0 ifTrue:[
    GsPackagePolicy currentOrNil ifNotNil:[:pp| pp categorysDo: aBlock for: self ].
  ].
  self env: envId baseCategorysDo: aBlock

]

{ #category : 'Browser Methods' }
Behavior >> includesSelector: aString environmentId: envId [

^ (self compiledMethodAt: aString environmentId: envId otherwise: nil
	usePackages: false) ~~ nil

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> methodDictForEnv: envId [
  ^ self methodDictForEnv: envId usePackages: false

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> methodDictForEnv: envId usePackages: usePkg [
 | dict |
 (self persistentMethodDictForEnv: envId ) ifNotNil:[:md |
   dict := self _copyDictForQuery: md .
 ].
 dict ifNil:[ dict := self _newMethodDictForQuery ].
 (envId == 0 and:[ usePkg]) ifTrue:[
   GsPackagePolicy currentOrNil ifNotNil:[:pp| pp copyMethodDictFor: self into: dict]
 ] ifFalse:[
   (self transientMethodDictForEnv: envId ) ifNotNil:[:md |
     dict addAll: md
   ].
 ].
 ^ dict

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> selectorsForEnvironment: envId [
  ^ self selectorsForEnvironment: envId usePackages: false

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> selectorsForEnvironment: envId usePackages: usePkg [

"Returns an Array of Symbols, consisting of all of the message selectors
 defined by the receiver.  (Selectors inherited from superclasses are not
 included.)  For keyword messages, the Symbol includes each of the keywords,
 concatenated together.
 If usePkg is true, result consists of persistent methods
 plus GsPackagePolicy methods ; if false  persistent methods plus
 session methods."

 <primitive: 2001>  "enter protected mode"
 | set prot |
 prot := System _protectedMode .
 [ | aDict |
   set := IdentitySet new.
   (aDict := self persistentMethodDictForEnv: envId ) ifNotNil:[
     set addAll: aDict keys.
   ].
   (envId == 0 and:[ usePkg]) ifTrue:[
     GsPackagePolicy currentOrNil ifNotNil:[:pp| pp  selectorsFor: self into: set].
   ] ifFalse:[
     (aDict := self transientMethodDictForEnv: envId) ifNotNil:[
       set addAll: aDict keys.
     ].
   ].
 ] ensure:[
   prot _leaveProtectedMode
 ].
 ^ set asArray .

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> whichClassIncludesSelector: aString environmentId: envId [
  ^ self whichClassIncludesSelector: aString environmentId: envId usePackages: false

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> whichClassIncludesSelector: aString environmentId: envId usePackages: usePkg [

"If the selector aString is in the receiver's method dictionary,
 returns the receiver.  Otherwise, returns the most immediate superclass
 of the receiver where aString is found as a message selector.  Returns
 nil if the selector is not in the method dictionary of the receiver or
 any of its superclasses.
 If usePkg is true, result consists of persistent methods
 plus GsPackagePolicy methods ; if false  persistent methods plus
 session methods."

  | currClass aSymbol |
  aSymbol := Symbol _existingWithAll: aString .
  aSymbol ifNil:[ ^ nil ].

  currClass := self.
  envId ~~ 0 ifTrue:[
    [ currClass == nil ] whileFalse:[
      (currClass compiledMethodAt: aSymbol environmentId: envId otherwise: nil
                  usePackages: usePkg) ifNotNil:[
         ^currClass
      ].
      currClass := currClass superclassForEnv: envId
    ].
  ] ifFalse:[
    [ currClass == nil ] whileFalse:[
      (currClass compiledMethodAt: aSymbol environmentId: envId otherwise: nil
              usePackages: usePkg) ifNotNil:[ ^ currClass ].
      currClass := currClass superClass
    ].
  ].
  ^ nil

]
