"
IndexManager is provides protocol for managing and maintaining indexed collections.
 The single instance of IndexManager should be accessed via the class message #current.
 In normal use, you will use IndexManager to turn autoCommit for index maintenance
 operations off and on and to define the dirtyObjectCommitThreshold and 
 percentTempObjSpaceCommitThreshold, which are control parameters for autoCommit.

 Note that autoCommit will also make the system respond to TransactionBacklog 
 notifications by commiting.

 IndexManager current tracks all instances of UnorderedCollection that have had indexes
 created for them. You may use IndexManager current to #removeAllIndexes, which removes
 indexes from all indexed collections in the system or you may use IndexManager 
 current to #removeAllIncompleteIndexes, which removes partial indexes from collections
 when index creation failed without completing.

 Automatic garbage collection of unreferenced UnorderedCollections is _not_ preformed, so
 one must explicitly remove all indexes from an UnorderedCollection that is no longer used.

 IndexManager may be subclassed.
"
Class {
	#name : 'IndexManager',
	#superclass : 'Object',
	#instVars : [
		'allIndexes',
		'autoCommit',
		'dirtyObjectCommitThreshold',
		'percentTempObjSpaceCommitThreshold',
		'useKeyEncryption'
	],
	#classInstVars : [
		'Current'
	],
	#gs_reservedoop : '121601',
	#category : nil
}
