"
RangeIndexReadStream, like its superclass BtreeReadStream, supports the
 composition of query results by providing access to a B-tree structure.  Its
 'next' and 'atEnd' methods are used the same way as those of
 BtreeReadStream in iterating through the B-tree.

 RangeIndexReadStream differs from BtreeReadStream in that it uses the reverse
 mappings to B-tree nodes that are found in a RangeEqualityIndex to obtain the
 next entry.  You can supply that index when you create the stream, and the
 index identifies the ordering used to return the entries.

Constraints:
	endNode: BtreeLeafNode
	endIndex: SmallInteger
	currentStack: Array
	rangeIndex: RangeEqualityIndex
	setIterationIndexes: Object

instvar rangeIndex - The RangeEqualityIndex for an instance of this class.

instvar setIterationIndexes -- An Array of Integers that indicates the 
  offset into BucketValueBags along the path.

"
Class {
	#name : 'RangeIndexReadStream',
	#superclass : 'BtreeReadStream',
	#instVars : [
		'rangeIndex',
		'setIterationIndexes'
	],
	#category : nil
}
