"
RcIdentityBag is a special kind of IdentityBag that provides much of the same 
functionality, but with no conflict for multiple sessions that add objects to the 
bag, and a single session that removes objects. 

Internally, RcIdentityBag is internally implemented using an Array of 
IdentityBags. Each session number corresponds to two IdentityBags, one for 
additions to the RcIdentityBag, and one for removed elements. Each logged-in 
session only modifies the IdentityBags corresponding to its own session number. 
Computing the current contents of an RcIdentityBag means combining the add 
bags, and removing all the remove bags.  While some cleanup of removed 
elements is automatic, an RcIdentityBag may require periodic manual cleanup. 

instance variable (not intended for public use):
    components: Array

"
Class {
	#name : 'RcIdentityBag',
	#superclass : 'IdentityBag',
	#instVars : [
		'components'
	],
	#gs_options : [
		'disallowGciStore',
		'traverseByCallback'
	],
	#gs_reservedoop : '105473',
	#category : nil
}
