"
An RcQueue (reduced-conflict queue) is an implementation of a FIFO queue that
 provides significantly reduced concurrency conflicts when used in an
 environment with multiple producers (users that add elements to the queue) and
 a single consumer (a user that removes items from the queue).  Producers are
 guaranteed not to conflict with each other, nor with a single consumer.  An
 RcQueue is implemented as a collection of RcQueueSessionComponents, each of
 which contains the queue elements submitted by a particular session.

Constraints:
	removalSeqNumbers: RcQueueRemovalSeqNumbers
	[elements]: RcQueueSessionComponent

instvar removalSeqNumbers -- An instance of the class RcQueueRemovalSeqNumbers 
  (essentially an Array of SmallIntegers) representing the order in which elements 
  are to be removed from the queue.

 Searching methods should be used with care because they tend to iterate 
 over the whole collection and nullify the concurrency conflict mechanisms
 built into RC classes.
"
Class {
	#name : 'RcQueue',
	#superclass : 'Collection',
	#instVars : [
		'removalSeqNumbers'
	],
	#gs_reservedoop : '82945',
	#category : nil
}
