Extension { #name : 'SmallScaledDecimal' }

{ #category : 'Private' }
SmallScaledDecimal class >> basicNew [
  ^ ScaledDecimal _basicNew 

]

{ #category : 'Storing and Loading' }
SmallScaledDecimal class >> loadFrom: passiveObj [
  | inst |
  inst := self fromStringLocaleC:  passiveObj upToSeparator .
  "no hasRead: here, since SmallScaledDecimal is a special"
  ^inst

]

{ #category : 'Private' }
SmallScaledDecimal >> _mantissa: m scale: s [
  "Disallowed"
   self shouldNotImplement: #_mantissa:scale: 

]

{ #category : 'Storing and Loading' }
SmallScaledDecimal >> containsIdentity [
  ^ true

]

{ #category : 'Testing' }
SmallScaledDecimal >> isSpecial [
  ^ true

]

{ #category : 'Accessing' }
SmallScaledDecimal >> mantissa [
  <primitive: 1117>
  ^ self _primitiveFailed: #mantissa

]

{ #category : 'Accessing' }
SmallScaledDecimal >> scale [
  <primitive: 1118>
  ^ self _primitiveFailed: #scale

]

{ #category : 'Storing and Loading' }
SmallScaledDecimal >> writeTo: passiveObj [

"Converts the receiver to its passive form and writes that information on
 passiveObj."

passiveObj writeClass: self class;
  nextPutAll: self asStringLocaleC;
  nextPut: $s ; nextPutAll: self scale asString ; space .

]
