Extension { #name : 'Error' }

{ #category : 'Formatting' }
Error >> buildMessageText [
^ self buildMessageText:(
  [ | str nArgs d |
    d := (LegacyErrNumMap atOrNil: gsNumber) ifNotNil:[:m | m atOrNil: 3].
    d ifNil:[  "no legacy error formatting, get generic details"
      1 to: (nArgs := gsArgs size)  do:[:n | | elem |
        str ifNil:[ str := String new ].
        elem := gsArgs atOrNil: n .
        (elem _isSymbol or:[ elem _isOneByteString]) ifTrue:[ str add: elem ]
           ifFalse:[  elem _isSmallInteger ifTrue:[ str add: elem asString ]
              ifFalse:[ str add: 'a ' ; add: elem class name ]].
        n < nArgs ifTrue:[ str add: ', ' ]
      ].
      gsDetails ifNotNil:[ :x |
        str ifNil:[ str := String new ]
            ifNotNil:[ str add:', ' ].
        str add: x  asString
      ].
    ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]
