Extension { #name : 'GsObjectSecurityPolicy' }

{ #category : 'Instance Creation' }
GsObjectSecurityPolicy class >> new [

"Returns a new GsObjectSecurityPolicy in the Repository aRepository.  If the
 maximum number of ObjectSecurityPolicies has already been created for aRepository,
 this generates an error.
 The new GsObjectSecurityPolicy is owned by the UserProfile of the current session,
 and has the default authorization of W----- (owner can read and write).

 After execution of this method, the current transaction must be committed
 before objects can be created in the GsObjectSecurityPolicy, object assigned to
 the objectSecurityPolicy, or the GsObjectSecurityPolicy used as argument to a
 defaultObjectSecurityPolicy: keyword in
 creation of UserProfiles.

 Requires the ObjectSecurityPolicyCreation privilege
 and WriteAccess to DataCuratorObjectSecurityPolicy.
 "

^ self newInRepository: SystemRepository

]

{ #category : 'Updating' }
GsObjectSecurityPolicy >> _objectSecurityPolicy: anObjectSecurityPolicy [

"Disallowed"

self shouldNotImplement: #_objectSecurityPolicy:

]

{ #category : 'Updating' }
GsObjectSecurityPolicy >> _primitiveAt: offset put: aValue [
"Disallowed"
self shouldNotImplement: #_primitiveAt:put:

]

{ #category : 'Instance migration' }
GsObjectSecurityPolicy >> _primitiveBecome: anObject forDict: aBoolean [
"Disallowed"
self shouldNotImplement: #_primitiveBecome:forDict:

]

{ #category : 'Conversion' }
GsObjectSecurityPolicy >> _setObjectSecurityPolicyId: anInt [

self _unsafeAt: 7 put: anInt

]

{ #category : 'Storing and Loading' }
GsObjectSecurityPolicy >> basicLoadFrom: passiveObj [
"Disallowed."
self shouldNotImplement: #basicLoadFrom:

]

{ #category : 'Storing and Loading' }
GsObjectSecurityPolicy >> basicLoadFrom: passiveObj size: aSize [
"Disallowed"
self shouldNotImplement: #basicLoadFrom:size:

]

{ #category : 'Storing and Loading' }
GsObjectSecurityPolicy >> basicLoadFromNoRead: passiveObj size: aSize [
"Disallowed"
self shouldNotImplement: #basicLoadFromNoRead:size:

]

{ #category : 'Storing and Loading' }
GsObjectSecurityPolicy >> basicLoadFromOld: passiveObj [
"Disallowed"
self shouldNotImplement: #basicLoadFromOld:

]

{ #category : 'Instance migration' }
GsObjectSecurityPolicy >> become: anObj [
"Disallowed"
self shouldNotImplement: #become:

]

{ #category : 'Instance migration' }
GsObjectSecurityPolicy >> changeClassTo: aCls [
"Disallowed"
self shouldNotImplement: #changeClassTo:

]

{ #category : 'Copying' }
GsObjectSecurityPolicy >> copy [

"Disallowed."

self shouldNotImplement: #copy

]

{ #category : 'Updating' }
GsObjectSecurityPolicy >> instVarAt: offset put: aValue [
"Disallowed"
self shouldNotImplement: #instVarAt:put:

]

{ #category : 'Storing and Loading' }
GsObjectSecurityPolicy >> loadFrom: passiveObj [
"Disallowed"
self shouldNotImplement: #loadFrom:

]

{ #category : 'Storing and Loading' }
GsObjectSecurityPolicy >> loadNamedIVsFrom: passiveObj [
"Disallowed"
self shouldNotImplement: #loadNamedIVsFrom:

]

{ #category : 'Storing and Loading' }
GsObjectSecurityPolicy >> loadVaryingFrom: passiveObj [
"Disallowed"
self shouldNotImplement: #loadVaryingFrom:

]

{ #category : 'Storing and Loading' }
GsObjectSecurityPolicy >> loadVaryingFrom: passiveObj size: aSize [
"Disallowed"
self shouldNotImplement: #loadVaryingFrom:size:

]

{ #category : 'Instance migration' }
GsObjectSecurityPolicy >> migrate [
"Disallowed"
self shouldNotImplement: #migrate

]

{ #category : 'Instance migration' }
GsObjectSecurityPolicy >> migrateFrom: anObj [
"Disallowed"
self shouldNotImplement: #migrateFrom:

]

{ #category : 'Instance migration' }
GsObjectSecurityPolicy >> migrateFrom: anObj instVarMap: aDict [
"Disallowed"
self shouldNotImplement: #migrateFrom:instVarMap:

]

{ #category : 'Instance migration' }
GsObjectSecurityPolicy >> migrateIndexable: anObj myClass: aCls otherClass: secondCls [
"Disallowed"
self shouldNotImplement: #migrateIndexable:myClass:otherClass:

]

{ #category : 'Updating' }
GsObjectSecurityPolicy >> nilFields [
"Disallowed"
self shouldNotImplement: #nilFields

]
