Extension { #name : 'GsNMethod' }

{ #category : 'Repository Conversion' }
GsNMethod >> _literalValToAssocations: aValue [
  "Returns a SymbolAssocation or an Array of SymbolAssocations
   thus returning all associations from the current symbolList whose value is
   identical to aValue.  If there are multiple qualifying associations
   with identical keys, the first association found with a given key is included
   in the result."
  | reverseDict tmps |
  reverseDict := (tmps := SessionTemps current) at: #GsRecompileValuesToKeys ifAbsent:[
    tmps at: #GsRecompileValuesToKeys put: IdentityDictionary new
  ].
  ^ reverseDict at: aValue ifAbsent:[ | keys values |
     keys := IdentitySet new .  values := { } .
     GsSession currentSession symbolList do:[ :symd |
       symd associationsDo:[ :assoc |
         (assoc value == aValue and:[ (keys includes: assoc key) == false]) ifTrue:[
           keys add: assoc key .
           values add: assoc.
         ]
       ].
     ].
     values size == 0 ifTrue:[ |vCls |
       ((vCls := aValue class) == ByteArray
           or:[ (vCls == Array and:[ aValue isInvariant])
           or:[ (aValue isKindOf: String) and:[ aValue isInvariant]]]) ifFalse:[
         Warning signal: 'cannot find key for optimized literal value oop ' ,
            aValue asOop asString , ' (a ' , aValue class name, ')' .
       ]
     ].
     ^ reverseDict at: aValue put: (values size == 1 ifTrue:[ values at: 1] ifFalse:[ values]).
  ]

]

{ #category : 'Debugging Support' }
GsNMethod >> _setBreakAtIp: ipOffset operation: opcFlags frame: fpOffset process: aGsProcess breakpointLevel: brkLevel [

"Set breakpoint at specified ipOffset.  ipOffset is an instruction offset,
 which is a absolute byte offset within the receiver.

 Checks that the receiver is not part of the implementation of the scheduler.

 opcFlags is a SmallInteger , fields have these masks
    opcode 		   16rFF
    includeMethodStartBcs 16r100 , a Boolean , only affects opcode==1
        when ipOffset == -1 .

 opcode  action
   0	 set or reenable method breakpoint
   1     set single step breakpoint (takes precedence over method break)
   2     delete method breakpoint or disabled method breakpoint
   3     delete single step breakpoint
   4     disable method breakpoint, no action if breakpoint not set
   5     set step-into breakpoint on a send bytecode .

  If ipOffset == -1, then apply the action to all step points within the
  method.

  To restrict breakpoint to a specific GsProcess, aGsProcess must be non-nil.

  For opcodes 1,5  to restrict breakpoint to a specific frame
  and/or GsProcess , fpOffset and/or aGsProcess must be non-nil. 

  If brkLevel must be a SmallInteger ,
  0 = signal to GCI , >= 1 signal to Smalltalk .
"

(ProcessorScheduler scheduler _criticalMethods includes: self) ifTrue:[
  ^ Error signal:'cannot set breakpoints within the ProcessorScheduler'
].
^ self __setBreakAtIp: ipOffset operation: opcFlags frame: fpOffset process: aGsProcess
       breakpointLevel: brkLevel

]

{ #category : 'Private' }
GsNMethod >> _recursiveSize: arr [
 | terminationSet |
  ((terminationSet := arr at: 1) includes: self) ifTrue:[ ^ self ].
  terminationSet add: self .
 arr at: 2 put:(arr at:2) + self physicalSizeOnDisk .

]

{ #category : 'Private' }
GsNMethod >> _recursiveSizeInMemory: arr [
 | terminationSet |
  self isCommitted ifTrue:[ ^ self ] .
  ((terminationSet := arr at: 1) includes: self) ifTrue:[ ^ self ].
  terminationSet add: self .
 arr at: 2 put:(arr at:2) + self physicalSizeOnDisk .

]


