"
Lag25000CmwcRandom is a seedable random generator with a period of over 10**240833. 

See also the class comments of Random and SeededRandom.

Lag25000CmwcRandom is a lag-25000 generator using the complementary multiply-with-carry algorithm 
to generate random numbers. It is slow to initialize, but once initialized it is the fastest 
subclass of Random.  Its period is so long that every possible sequence of 24994 successive 
32-bit integers appears somewhere in its output, making it suitable for generating random 
n-tuples where n<24994. Its output is fair in that the number of 0 bits and 1 bits in the 
full sequence are equal.

This generator is recommended for most uses where its initialization time can be tolerated, 
but it is *not* a cryptographically secure generator, so for applications like key generation 
you should consider using HostRandom, once you satisfy yourself that HostRandom is secure 
enough on your operating system.

When you do not need a repeatable sequence of random numbers, an instance of Lag25000CmwcRandom 
can be created with

    Lag25000CmwcRandom new

which will obtain the needed seed bits from the HostRandom.

When you need a repeatable sequence of random numbers, an instance of Lag25000CmwcRandom can 
be created with

    Lag25000CmwcRandom seed: aSmallInteger

which will use the given SmallInteger to seed a Lag1MwcRandom, which will then provide the seeds 
for the Lag25000CmwcRandom.

You can also allow the seed bits to be initialized from the HostRandom, then retrive that state 
by sending #fullState. That state can later be restored by sending the retrieved state as 
an argument to #fullState:.
"
Class {
	#name : 'Lag25000CmwcRandom',
	#superclass : 'SeededRandom',
	#category : nil
}
