Extension { #name : 'CircularTestResourceTestCase' }

{ #category : 'accessing' }
CircularTestResourceTestCase class >> resources [
	^super resources, { SimpleTestResourceCircular }

]

{ #category : 'utility' }
CircularTestResourceTestCase >> clearOuterResourceStateDuring: aBlock [
	"To let the test run at all, we only make it circular when the preventAvailability instvar is set."

	^super clearOuterResourceStateDuring:
		[SimpleTestResourceCircular reset.
		self deny: SimpleTestResourceCircular1 isAlreadyAvailable
			description: 'SimpleTestResourceCircular1 should never be available'.
		SimpleTestResourceCircular preventAvailabilityDuring:
			[self should: aBlock raise: TestResult failure].
		self deny: SimpleTestResourceCircular isAlreadyAvailable
			description: 'SimpleTestResourceCircular was set up despite having circularity set'].

]

{ #category : 'running' }
CircularTestResourceTestCase >> testTearDownOrder [
	SimpleTestResourceCircular preventAvailabilityDuring:
		[self should: [SimpleTestResourceCircular reset; isAvailable] raise: TestResult failure.
		self assert: SimpleTestResourceCircular rawCurrentForTest == false
			description: 'Circular resource not in failed setUp state'.
		self assert: SimpleTestResourceCircular1 rawCurrentForTest == false
			description: 'Circular resource not in failed setUp state'.
		super testTearDownOrder.
		self assert: SimpleTestResourceCircular1 rawCurrentForTest == nil
			description: 'Circular resource not in failed setUp state'.
		self assert: SimpleTestResourceCircular rawCurrentForTest == nil
			description: 'Circular resource not reset after pre-tearDown iteration'].

]
