Extension { #name : 'HostRandom' }

{ #category : 'initialize-release' }
HostRandom class >> initialize [
	singleton := self basicNew

]

{ #category : 'instance creation' }
HostRandom class >> new [
	"Answer the singleton instance, opening /dev/urandom if not already open."

	singleton open.
	^singleton

]

{ #category : 'instance creation' }
HostRandom class >> seed: anInteger [
	"Answer a seeded random number generator seeded from the given SmallInteger"

	ImproperOperation
		signal: 'HostRandom uses the random number generator of the host random number generator, and cannot be seeded.'

]

{ #category : 'public' }
HostRandom >> close [
	"Close /dev/urandom if open."

	self file ifNotNil:[:file |
		file close
					ifNil: [IOError signal: GsFile serverErrorString]
					ifNotNil: [SessionTemps current removeKey: #GsHostRandomFile ]]


]

{ #category : 'private' }
HostRandom >> file [
	"Answer my file (/dev/urandom), if I have one, otherwise nil"

	^ SessionTemps current at: #GsHostRandomFile otherwise: nil

]

{ #category : 'public' }
HostRandom >> integer [
	"Answer a random nonnegative 32-bit integer."

	| int file |
	file := self file.
	(file ~~ nil and: [file isOpen])
		ifFalse: [ImproperOperation signal: 'This HostRandom is closed'].
	int := 0.
	4 timesRepeat: [int := (int bitShift: 8) + file nextByte].
	^int


]

{ #category : 'public' }
HostRandom >> isOpen [
	"Answer whether /dev/urandom is open"

	^ self file ifNil:[ false ] ifNotNil:[:f | f isOpen]

]

{ #category : 'public' }
HostRandom >> open [
	"Open /dev/urandom if not already open."

	| temps key file |
	file := (temps := SessionTemps current)  at:(key := #GsHostRandomFile)  otherwise: nil .
     file ifNil: [
       file := temps at: key put: (GsFile openOnServer: '/dev/urandom' mode: 'r').
	     file ifNil:[ IOError signal: GsFile serverErrorString ]
     ]

]
