Extension { #name : 'PositionableStreamLegacy' }

{ #category : 'ANSI Methods' }
PositionableStreamLegacy class >> compilePositionMethods [

"Compile ANSI, Legacy or Warning as default methods (see bug #39503)"

| flag selector string |
flag := Globals at: #'PositionableStream_position' ifAbsent: [#'Legacy'].
selector :=
	flag == #'ANSI'		ifTrue:  [#'positionA'] ifFalse: [
	flag == #'Legacy'	ifTrue:  [#'positionL'] ifFalse: [
	flag == #'Warning'	ifTrue:  [#'positionW'] ifFalse: [
	self error: 'Invalid value for flag!']]].
string := (self compiledMethodAt: selector) sourceString.
string := (string copyFrom: 1 to: 8) , (string copyFrom: 10 to: string size).
self
	compileMethod: string
	dictionaries: GsCurrentSession currentSession symbolList
	category: 'Positioning' environmentId: 0 .
selector := (selector , ':') asSymbol.
string := (self compiledMethodAt: selector) sourceString.
string := (string copyFrom: 1 to: 8) , (string copyFrom: 10 to: string size).
self
	compileMethod: string
	dictionaries: GsCurrentSession currentSession symbolList
	category: 'Positioning' environmentId: 0 .
^true.

]

{ #category : 'Portable Methods' }
PositionableStreamLegacy class >> isLegacyStreamImplementation [

^true

]

{ #category : 'Portable Methods' }
PositionableStreamLegacy class >> isPortableStreamImplementation [

^false

]

{ #category : 'Instance Creation' }
PositionableStreamLegacy class >> on: aCollection [

"Returns an instance of the receiver that can stream over the elements of
 aCollection."

| newStream |

newStream := self _basicNew.
newStream _initStreamWith: aCollection.
^ newStream

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> _collection [

"Returns the collection of the receiver."

^itsCollection

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> collection [

"Returns the collection of the receiver."

^itsCollection

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> _initStreamWith: aCollection [

"Initialize the receiver's 'itsCollection' instance variable to be
 aCollection."

itsCollection := aCollection.
position := 1.

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> _positionError: anInteger [

"Returns an error message that anInteger is out of bounds of the Collection."

^ self _error: #rtErrBadStreamPosition args: { anInteger }

]

{ #category : 'Testing' }
PositionableStreamLegacy >> atBeginning [
"Answer true if the stream is positioned at the beginning"

^position == 1

]

{ #category : 'Testing' }
PositionableStreamLegacy >> atEnd [

"Returns true if the receiver cannot access any more objects, false if it can."

^ position > itsCollection size

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> backup [

"Backs up the receiver one position."

self skip: -1

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> contents [

"Returns the Collection associated with the receiver (that is,
 the sequence of objects that the receiver may access)."

^itsCollection

]

{ #category : 'Testing' }
PositionableStreamLegacy >> isEmpty [

"Returns true if the collection that the receiver accesses contains
 no elements; otherwise returns false."

^ itsCollection size == 0

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> next: count [

"Returns the next count elements in the receiver's collection."

| result |
result := itsCollection species new.
count timesRepeat: [ result add: self next ].
^result

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> next: count into: anObject [

"Stores the next count elements in the receiver's collection into the
 given object.  Returns the argument anObject."

| idx |
idx := 1.
count timesRepeat: [ anObject at: idx put: self next. idx := idx + 1 ].
^anObject

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> nextLine [

| result cr lf char chrcls |
result := itsCollection species new.
cr := (chrcls:= Character) cr.
lf := chrcls  lf.
[(char := self peek) ~~ nil and:[ char ~~ cr and: [char ~~ lf]]] whileTrue: [
  result add: self next
].
self atEnd ifFalse: [
  self next.
  (self atEnd == false and: [char == cr and: [self peek == lf]]) ifTrue: [
    self next.
  ].
].
^result

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> nextWord [

 "Assume that the receiver's collection is a kind of String.  Returns the
  next word in the string or nil if there is no next word."

 | result ch |
 result := itsCollection species new.
 self skipSeparators.
 [ (ch := self peek) ~~ nil and: [ch isSeparator == false]] whileTrue: [
   result add: self next
 ].
 result size == 0
    ifTrue: [^nil]
    ifFalse: [^result]
]

{ #category : 'Accessing' }
PositionableStreamLegacy >> peek [

"Returns the next element in the collection, but does not alter the current
 position reference.  If the receiver is at the end of the collection, returns
 nil."

| pos coll |
pos := position .
pos <= (coll := itsCollection) size ifFalse:[ ^ nil ]. "inline atEnd"
^ coll at: pos

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> peek2 [

"Peeks at the second incoming object."

| pos coll |
pos := position.
pos < (coll := itsCollection) size ifFalse:[ ^ nil ]. "inline atEnd"
^ coll at: pos + 1

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> peekFor: anObject [

self peek = anObject ifTrue: [
  self next.
  ^true.
].
^false.

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> peekWord [

"Assume that the receiver's collection is a kind of String.  Returns the
 next word in the string without moving the receiver's position."

| result pos |
pos := self position.
result := self nextWord .
self position: pos.
^result

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> position [

"Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n.

 This is the ANSI method. See Bug #39503."

^position - 1.

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> position: anInteger [

"Sets the receiver's current position reference for accessing the collection to
 be anInteger.  If anInteger is not within the bounds of the collection,
 generates an error.

 This is the ANSI method. See Bug #39503."

  self positionL: anInteger + 1.

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> positionA [

"Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n.

 This is the ANSI method. See Bug #39503."

^position - 1.

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> positionA: anInteger [

"Sets the receiver's current position reference for accessing the collection to
 be anInteger.  If anInteger is not within the bounds of the collection,
 generates an error.

 This is the ANSI method. See Bug #39503."

	self positionL: anInteger + 1.

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> positionL [

"Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n.

 This is the 'Legacy' (non-ANSI) method. See Bug #39503."

^position

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> positionL: anInteger [

"Sets the receiver's current position reference for accessing the collection to
 be anInteger.  If anInteger is not within the bounds of the collection,
 generates an error.

 This is the 'Legacy' (non-ANSI) method. See Bug #39503."

 (anInteger > 0 and:[ anInteger <= (itsCollection size + 1) ])
   ifTrue: [position := anInteger]
   ifFalse: [self _positionError: anInteger]

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> positionW [

"This is the 'Warning' behavior to be called when you think you have replaced
 all references to #'position' with #'positionL' or #'positionA'.
 Replace #'position' with this when you think there are no senders."

Warning signal:'In PositionableStreamLegacy >> positionW'.
^self positionL.

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> positionW: anInteger [

"This is the 'Warning' behavior to be called when you think you have replaced
 all references to #'position:' with #'positionL:' or #'positionA:'.
 Replace #'position:' with this when you think there are no senders."

Warning signal:'In PositionableStreamLegacy >> positionW'.
^self positionL: anInteger.

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> reset [

"Sets the receiver's position to the beginning of the sequence of objects."

position := 1

]

{ #category : 'Positioning' }
PositionableStreamLegacy >> setToEnd [

"Sets the receiver's position to the end of the sequence of objects."

self positionL: itsCollection size + 1

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> skip: amount [

"Sets the receiver's position to position+amount."

self position: self position + amount

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> skipAny: chars [

"Skip past all Characters in chars.  Returns the number of Characters skipped."

| skipped ch |
skipped := 0.
[ (ch := self peek) ~~ nil and: [(chars includesIdentical: ch )]] whileTrue: [
  self next.
  skipped := skipped + 1.
].
^skipped

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> skipSeparators [

"Skip any objects immediately next in the stream that respond true to
 isSeparator."
| ch |
[ (ch := self peek) ~~ nil and:[ ch isSeparator ]] whileTrue: [ self next ]

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> throughAll: matchCollection [

"Returns a collection of objects from the receiver up to and including the
sequence of objects in the argument 'matchCollection', leaving the stream
positioned after the sequence.  If the sequence of objects is not found, this
returns the remaining contents of the receiver and leaves me positioned
at my end."

| numMatched numToMatch result  |

numMatched := 0.
result := itsCollection species new.
numToMatch := matchCollection size.
[self atEnd or: [numMatched == numToMatch]]
     whileFalse:
           [self next = (matchCollection at: numMatched + 1)
                ifTrue: [numMatched := numMatched + 1]
          ifFalse: [position := position - numMatched - 1.
                        result add: self next.
                        numMatched := 0]
].

"add matched or partially matched chars"
position := position - numMatched.
numMatched timesRepeat: [result add: self next].

^ result.

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> upTo: anObject [

"Returns all objects up to the given value or the end of the stream."

| result obj |
result := itsCollection species new.
[ true ] whileTrue:[
  self atEnd ifTrue:[ ^ result ].
  obj := self next .
  anObject = obj ifTrue:[ ^ result ].
  result add: obj
]

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> upTo: anObject do: aBlock [

"Sends each object encountered to the given block until the end of stream
 or the given value is encountered.  Returns the receiver."

| obj |
[ true ] whileTrue:[
  self atEnd ifTrue:[ ^ self ].
  obj := self next .
  anObject = obj ifTrue:[ ^ self ].
  aBlock value: obj
]

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> upToAll: matchCollection [

"Returns a collection of objects from the receiver up to, but not including,
 the sequence of objects in the argument 'matchCollection', leaving the stream
 positioned to read the sequence.  If the sequence of objects is not found,
 this returns the remaining contents of the receiver and leaves the stream
 positioned at the end."

| numMatched numToMatch result |

numMatched := 0.
result := itsCollection species new.
numToMatch := matchCollection size.
[self atEnd or: [numMatched == numToMatch]] whileFalse: [
  self next = (matchCollection at: numMatched + 1)
      ifTrue: [numMatched := numMatched + 1]
      ifFalse: [position := position - numMatched - 1.
    		result add: self next.
                numMatched := 0]
].
"Position before any partial or complete match we might have found."
position := position - numMatched.

"If the match was not complete, must add any partially matched chars."
numMatched ~~ numToMatch
  ifTrue: [numMatched timesRepeat: [result add: self next]].

^ result.

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> upToAny: objects [

"Returns all objects up to one of the given collection of objects or the end
 of the stream."

| result obj |
result := itsCollection species new.
[ (obj := self peek) ~~ nil and: [(objects includesIdentical: obj) == false]] whileTrue: [
  result add: self next
].
self atEnd ifFalse: [
  self next
].
^result

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> upToAny: objects do: aBlock [

"Send each Character encountered to aBlock until the end of stream
 or one of the given Characters is encountered."
| obj |
[(obj := self peek) ~~ nil and: [(objects includesIdentical: obj) == false]] whileTrue: [
  aBlock value: self next
].
self atEnd ifFalse: [ self next ].

]

{ #category : 'Accessing' }
PositionableStreamLegacy >> upToEnd [

"Returns all Characters from the current position to the end of the stream."

| result end coll |
end := (coll := itsCollection) size .
result := coll copyFrom: position to: end .
position :=  end + 1 .
^ result

]
