Extension { #name : 'SUnitTest' }

{ #category : 'private' }
SUnitTest >> assertForTestResult: aResult runCount: aRunCount passed: aPassedCount failed: aFailureCount errors: anErrorCount [

	self
		assert: aResult runCount = aRunCount;
		assert: aResult passedCount = aPassedCount;
		assert: aResult failureCount = aFailureCount;
		assert: aResult errorCount = anErrorCount

]

{ #category : 'private' }
SUnitTest >> error [
	3 zork

]

{ #category : 'testing' }
SUnitTest >> errorShouldntRaise [
	self
		shouldnt: [self someMessageThatIsntUnderstood]
		raise: SUnitNameResolver notificationObject

]

{ #category : 'private' }
SUnitTest >> fail [
	self assert: false

]

{ #category : 'accessing' }
SUnitTest >> hasRun [
	^hasRun

]

{ #category : 'accessing' }
SUnitTest >> hasSetup [
	^hasSetup

]

{ #category : 'private' }
SUnitTest >> noop [

]

{ #category : 'private' }
SUnitTest >> setRun [
	hasRun := true

]

{ #category : 'running' }
SUnitTest >> setUp [
	hasSetup := true

]

{ #category : 'testing' }
SUnitTest >> testAssert [
	self assert: true.
	self deny: false

]

{ #category : 'testing' }
SUnitTest >> testDefects [
	| result suite error failure |
	suite := TestSuite new.
	suite addTest: (error := self class selector: #error).
	suite addTest: (failure := self class selector: #fail).
	result := suite run.
	self assert: result defects asArray = { error . failure } .
	self
		assertForTestResult: result
		runCount: 2
		passed: 0
		failed: 1
		errors: 1

]

{ #category : 'testing' }
SUnitTest >> testDialectLocalizedException [

	self
		should: [TestResult signalFailureWith: 'Foo']
		raise: TestResult failure.
	self
		should: [TestResult signalErrorWith: 'Foo']
		raise: TestResult error.

]

{ #category : 'testing' }
SUnitTest >> testError [

	| case result |

	case := self class selector: #error.
	result := case run.
	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 0
		errors: 1.

	case := self class selector: #errorShouldntRaise.
	result := case run.
	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 0
		errors: 1

]

{ #category : 'testing' }
SUnitTest >> testException [

	self
		should: [self error: 'foo']
		raise: TestResult error

]

{ #category : 'testing' }
SUnitTest >> testFail [

	| case result |

	case := self class selector: #fail.
	result := case run.

	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 1
		errors: 0

]

{ #category : 'testing' }
SUnitTest >> testIsNotRerunOnDebug [

	| case |

	case := self class selector: #testRanOnlyOnce.
	case run.
	case debug

]

{ #category : 'testing' }
SUnitTest >> testRan [

	| case |

	case := self class selector: #setRun.
	case run.
	self assert: case hasSetup.
	self assert: case hasRun

]

{ #category : 'testing' }
SUnitTest >> testRanOnlyOnce [

	self assert: hasRanOnce ~= true.
	hasRanOnce := true

]

{ #category : 'testing' }
SUnitTest >> testResult [

	| case result |

	case := self class selector: #noop.
	result := case run.

	self
		assertForTestResult: result
		runCount: 1
		passed: 1
		failed: 0
		errors: 0

]

{ #category : 'testing' }
SUnitTest >> testRunning [

	(SUnitDelay forSeconds: 2) wait

]

{ #category : 'testing' }
SUnitTest >> testShould [

	self
		should: [true];
		shouldnt: [false]

]

{ #category : 'testing' }
SUnitTest >> testSuite [

	| suite result |

	suite := TestSuite new.
	suite
		addTest: (self class selector: #noop);
		addTest: (self class selector: #fail);
		addTest: (self class selector: #error).

	result := suite run.

	self
		assertForTestResult: result
		runCount: 3
		passed: 1
		failed: 1
		errors: 1

]
