Extension { #name : 'SeededRandom' }

{ #category : 'instance creation' }
SeededRandom class >> new [
	^ self basicNew initialize

]

{ #category : 'instance creation' }
SeededRandom class >> seed: anInteger [

	^ self new seed: anInteger

]

{ #category : 'public' }
SeededRandom >> fullState [

	"Answers the current state of the generator. The state represents in what sequence random
  numbers will be generated, and where in that sequence the generator is. This generator, or
  another generator of the same class, may be later set to this state by giving this state
  as an argument to the fullState: method, after which it will generate random numbers in
  the same sequence as the receiver will after receiving #fullState."

	"If I have no state yet, initialize myself from HostRandom"
	index == nil ifTrue: [self setSeedFromHost].
	^{index.
	carry.
	seeds copy}

]

{ #category : 'public' }
SeededRandom >> fullState: fullState [

	"Resets the state of the generator to some point in its sequence; the point at which fullState was
	obtained by sending #fullState to the generator or another generator of the same class.
	After receiving this message, the sequence of random numbers generated will match the
	ones generated after #fullState was received.

	The given fullState must be an Array of size 3. The first element is an integer, the index,
	which must be in the range [1..lag].
	The second element is the carry, which must be an integer in the range [0..multiplier-1].
	The third element is the seedArray. The size of seedArray mut be lag. Each seed in the
	array must be a 32-bit nonnegative integer.
	Depending on the subclass, it may be an error if *all* of the seeds and the carry to be zero,
	or for all of them to be their maximum legal value; MWC requires that at least one must be of
	another value. CMWC does not have this requirement."

	self validateFullState: fullState.
	index := fullState at: 1.
	carry := fullState at: 2.
	seeds := (fullState at: 3) copy

]
