Extension { #name : 'TestAsserter' }

{ #category : 'other' }
TestAsserter class >> assert: aBoolean description: aString [
	aBoolean ifFalse:
		[self logFailure: aString.
		TestResult failure signal: aString].

]

{ #category : 'other' }
TestAsserter class >> failureLog [
	^SUnitNameResolver defaultLogDevice

]

{ #category : 'other' }
TestAsserter class >> isLogging [
	"By default, we're not logging failures. Override in subclasses as desired."

	^false

]

{ #category : 'other' }
TestAsserter class >> logFailure: aString [
	self isLogging ifTrue:
		[self failureLog cr; nextPutAll: aString; flush].

]

{ #category : 'asserting' }
TestAsserter >> assert: aBoolean [
	aBoolean ifFalse:
		[self logFailure: 'Assertion failed'.
		TestResult failure signal: 'Assertion failed'].

]

{ #category : 'asserting' }
TestAsserter >> assert: aBoolean description: aString [
	aBoolean ifFalse:
		[self logFailure: aString.
		TestResult failure signal: aString].

]

{ #category : 'asserting' }
TestAsserter >> assert: aBoolean description: aString resumable: resumableBoolean [
	| exception |
	aBoolean ifFalse:
		[self logFailure: aString.
		exception := resumableBoolean
			ifTrue: [TestResult resumableFailure]
			ifFalse: [TestResult failure].
		exception signal: aString].

]

{ #category : 'asserting' }
TestAsserter >> assert: anObject equals: otherObj [
  anObject = otherObj ifFalse:[ | a b |
    a := anObject printString .
    b := otherObj printString .
    a size > 100 ifTrue:[ a size: 100; addAll:'... ' ].
    b size > 100 ifTrue:[ b size: 100; addAll:'... ' ].
	  self
		 assert: false
		 description: a, ' is not equal to ' , b .
  ].

]

{ #category : 'asserting' }
TestAsserter >> assert: anObject identical: otherObj [
  anObject == otherObj ifFalse:[ | a b |
    a := 'oop ', anObject asOop asString,' ', anObject printString .
    b := 'oop ', otherObj asOop asString,' ', otherObj printString .
    a size > 100 ifTrue:[ a size: 100; addAll:'... ' ].
    b size > 100 ifTrue:[ b size: 100; addAll:'... ' ].
	  self
		 assert: false
		 description: a, ' is not identical to ' , b .
  ].

]

{ #category : 'asserting' }
TestAsserter >> deny: aBoolean [
	self assert: aBoolean not.

]

{ #category : 'asserting' }
TestAsserter >> deny: aBoolean description: aString [
	self assert: aBoolean not description: aString.

]

{ #category : 'asserting' }
TestAsserter >> deny: aBoolean description: aString resumable: resumableBoolean [
	self assert: aBoolean not description: aString resumable: resumableBoolean.

]

{ #category : 'asserting' }
TestAsserter >> deny: anObject equals: anotherObject [
	self
		deny: anObject = anotherObject
		description: anObject printString , ' is equal to ' , anotherObject printString.

]

{ #category : 'asserting' }
TestAsserter >> executeShould: aBlock inScopeOf: anObject [

	| expectedErrorNumber |
	(anObject isKindOf: Integer)
		ifTrue: [expectedErrorNumber := anObject]
		ifFalse:
			[(anObject isKindOf: Symbol)
				ifTrue: [expectedErrorNumber := ErrorSymbols at: anObject]
				ifFalse:
					[^
					[aBlock value.
					false] sunitOn: anObject do: [:ex | ^true]]].
	^
	[aBlock value.
	false] sunitOn: Error
			do: [:ex | expectedErrorNumber = ex number ifTrue: [^true] ifFalse: [ex pass]]

]

{ #category : 'asserting' }
TestAsserter >> fail [
	self assert: false
]

{ #category : 'asserting' }
TestAsserter >> fail: descriptionString [
	self assert: false description: descriptionString
]

{ #category : 'asserting' }
TestAsserter >> logFailure: aString [
	self class logFailure: aString.

]

{ #category : 'asserting' }
TestAsserter >> should: aBlock raise: anObject [

	| expectedErrorNumber actualErrorNumber |
	(anObject isKindOf: Integer) ifTrue: [
		expectedErrorNumber := anObject.
	] ifFalse: [(anObject isKindOf: Symbol) ifTrue: [
		expectedErrorNumber := ErrorSymbols at: anObject.
	] ifFalse: [
		^self assert: (self executeShould: aBlock inScopeOf: anObject).
	]].
	aBlock on: Error do: [:ex |
	   actualErrorNumber := ex number.
	].
	self should: [actualErrorNumber = expectedErrorNumber].

]

{ #category : 'asserting' }
TestAsserter >> should: aBlock raise: anExceptionalEvent description: aString [
	self
		assert: (self executeShould: aBlock inScopeOf: anExceptionalEvent)
		description: aString

]

{ #category : 'asserting' }
TestAsserter >> shouldnt: aBlock raise: anExceptionalEvent [
	self assert: (self executeShould: aBlock inScopeOf: anExceptionalEvent) not.

]

{ #category : 'asserting' }
TestAsserter >> shouldnt: aBlock raise: anExceptionalEvent description: aString [
	self
		assert: (self executeShould: aBlock inScopeOf: anExceptionalEvent) not
 		description: aString.

]
