Extension { #name : 'TestSuite' }

{ #category : 'Creation' }
TestSuite class >> named: aString [

	^self new
		name: aString;
		yourself

]

{ #category : 'Dependencies' }
TestSuite >> addDependentToHierachy: anObject [
	self sunitAddDependent: anObject.
	self tests do: [ :each | each addDependentToHierachy: anObject]

]

{ #category : 'Accessing' }
TestSuite >> addTest: aTest [
	self tests add: aTest

]

{ #category : 'Accessing' }
TestSuite >> addTests: aCollection [
	aCollection do: [:eachTest | self addTest: eachTest]

]

{ #category : 'Running' }
TestSuite >> debug [

	self tests do: [:each | each debug]

]

{ #category : 'Accessing' }
TestSuite >> defaultResources [
	^self tests
		inject: OrderedCollection new
		into:
			[:coll :testCase |
			testCase resources do:
				[:each |
				(coll includes: each) ifFalse: [coll add: each]].
			coll]

]

{ #category : 'Accessing' }
TestSuite >> name [

	^name

]

{ #category : 'Accessing' }
TestSuite >> name: aString [

	name := aString

]

{ #category : 'Dependencies' }
TestSuite >> removeDependentFromHierachy: anObject [
	self sunitRemoveDependent: anObject.
	self tests do: [ :each | each removeDependentFromHierachy: anObject]

]

{ #category : 'Accessing' }
TestSuite >> resources [
	resources == nil  ifTrue: [resources := self defaultResources].
	^resources

]

{ #category : 'Accessing' }
TestSuite >> resources: someOrderedTestResourceClasses [
	"The parameter should understand reverseDo: and should not contain duplicates."

	resources := someOrderedTestResourceClasses

]

{ #category : 'Running' }
TestSuite >> run [
	| result |
	result := TestResult new.
	[self run: result]
		ensure: [TestResource resetResources: self resources].
	^result

]

{ #category : 'Running' }
TestSuite >> run: aResult [
	self tests do: [:each |
		self sunitChanged: each.
		each run: aResult]

]

{ #category : 'Accessing' }
TestSuite >> tests [
	tests == nil  ifTrue: [tests := OrderedCollection new].
	^tests

]
