Extension { #name : 'TranscriptStreamPortable' }

{ #category : 'initialization' }
TranscriptStreamPortable class >> initialize [
	"self initialize"

	Globals at: #Transcript put: self new.
	 "world write permission"
	(Globals associationAt: #Transcript) objectSecurityPolicy: nil

]

{ #category : 'Adding' }
TranscriptStreamPortable >> _nextPut: anObject [
"see PrintStream>>_nextPut:"

self nextPut: anObject

]

{ #category : 'Character writing' }
TranscriptStreamPortable >> crlf [
"Append a carriage return character followed by a line feed character to the receiver."

self nextPut: Character cr; nextPut: Character lf

]

{ #category : 'Character writing' }
TranscriptStreamPortable >> crtab [
"Append a return character, followed by a single tab character, to the
receiver."

| str chr |
(str := String new:2) at: 1 put: (chr := Character) cr;
  at: 2 put: chr tab .
^ self nextPutAll: str

]

{ #category : 'Character writing' }
TranscriptStreamPortable >> crtab: anInteger [
"Append a return character, followed by anInteger tab characters, to the
receiver."

| str chr tab |
(str := String new: 1) at: 1 put: (chr := Character) cr.
tab := chr tab .
anInteger timesRepeat: [ str add: tab] .
self nextPutAll: str 

]

{ #category : 'private' }
TranscriptStreamPortable >> endEntry [

	self mutex critical: [ | strm contents |
		contents := (strm := self stream) contents.
		strm reset.
		(contents size > 1 and: [ (contents at: 1) = Character lf])
			ifTrue: [
				"gciLogServer tacks a lf on end of previous contents"
				contents := contents copyFrom: 2 to: contents size].
		GsFile gciLogServer: contents ].

]

{ #category : 'ANSI' }
TranscriptStreamPortable >> flush [

	self endEntry

]

{ #category : 'private' }
TranscriptStreamPortable >> mutex [
	| tmps |
  ^ ((tmps := SessionTemps current)at: #TranscriptStream_SessionMutex otherwise: nil)
	     ifNil:[ tmps at: #TranscriptStream_SessionMutex
			put: Semaphore forMutualExclusion ]

]

{ #category : 'Adding' }
TranscriptStreamPortable >> nextPut: anObject [

	self mutex critical: [ ^ self stream nextPut: anObject ]

]

{ #category : 'Adding' }
TranscriptStreamPortable >> nextPutAll: aCollection [

	self mutex critical: [ ^self stream nextPutAll: aCollection ]

]

{ #category : 'Adding' }
TranscriptStreamPortable >> show: anObject [

	self nextPutAll: anObject printString.
	self endEntry

]

{ #category : 'Character writing' }
TranscriptStreamPortable >> space: anInteger [
"Append anInteger space characters to the receiver."

| str | 
str := String new: anInteger .
1 to: anInteger do:[:n |str at: n put: $   ].
self nextPutAll: str .

]

{ #category : 'private' }
TranscriptStreamPortable >> stream [
	| tmps |
	^ ((tmps := SessionTemps current) at: #'TranscriptStream_SessionStream' otherwise: nil)
		ifNil:[ tmps at: #'TranscriptStream_SessionStream'
				put: (AppendStream on: String new) ]


]

{ #category : 'Character writing' }
TranscriptStreamPortable >> tab: anInteger [
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [self tab]

]
{ #category : 'Adding' }
TranscriptStreamPortable >> nextPutAllBytes: aCharacterCollection [
  ^ self shouldNotImplement: #nextPutAllBytes: 
]
{ #category : 'Testing' }
TranscriptStreamPortable >> atEnd [
  ^ self shouldNotImplement: #atEnd
]
{ #category : 'Accessing' }
TranscriptStreamPortable >> next [
  ^ self shouldNotImplement: #next
]

