Extension { #name : 'WriteStreamLegacy' }

{ #category : 'Instance Creation' }
WriteStreamLegacy class >> new [

"Disallowed.  To create a new stream, use the class method on: instead."

self shouldNotImplement: #new

]

{ #category : 'Instance Creation' }
WriteStreamLegacy class >> with: aCollection [

"Returns an instance of the receiver open for writing. that is positioned at the end of
 aCollection."
   | res |
   (res := self on: aCollection) setToEnd .
   ^ res

]

{ #category : 'Adding' }
WriteStreamLegacy >> _nextPut: anObject [
"see PrintStream>>_nextPut:"

itsCollection at: position put: anObject.
position := position + 1.
^ anObject

]

{ #category : 'Accessing' }
WriteStreamLegacy >> contents [

"WriteStreams return the portion of their collection that has been written:
 the collection up to the next write-position."

position < 2 ifTrue: [ ^itsCollection species new ].
^itsCollection copyFrom: 1 to: position-1

]

{ #category : 'Character writing' }
WriteStreamLegacy >> crlf [
"Append a carriage return character followed by a line feed character to the receiver."

self nextPutAll: CrLf .

]

{ #category : 'Character writing' }
WriteStreamLegacy >> crtab [
"Append a return character, followed by a single tab character, to the
receiver."

self nextPutAll: CrTab .

]

{ #category : 'Character writing' }
WriteStreamLegacy >> crtab: anInteger [
"Append a return character, followed by anInteger tab characters, to the
receiver."

self nextPut: Cr     .
anInteger timesRepeat: [self nextPut: Tab ]

]

{ #category : 'ANSI' }
WriteStreamLegacy >> flush [
	"Update a stream's backing store.
	Upon return, if the receiver is a write-back stream, the state of the
	stream backing store must be consistent with the current state of the
	receiver.
	If the receiver is not a write-back stream, the effect of this
	message is unspecified."

	"We do nothing; this method is provided for ANSI compatibility"

]

{ #category : 'Accessing' }
WriteStreamLegacy >> next [

"Disallowed.  You cannot read an instance."

self shouldNotImplement: #next

]

{ #category : 'Adding' }
WriteStreamLegacy >> nextPut: anObject [

"Inserts anObject as the next element that the receiver can access for writing.
 Returns anObject."

^ self _nextPut: anObject

]

{ #category : 'Adding' }
WriteStreamLegacy >> nextPutAll: aCollection [

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection."

position == (itsCollection size + 1)
ifFalse:
  [ ^ super nextPutAll: aCollection ].
itsCollection addAll: aCollection.
position := position + (aCollection size).
^ aCollection

]

{ #category : 'Adding' }
WriteStreamLegacy >> nextPutAllBytes: aCharacterCollection [

"Inserts the byte contents of aCharacterCollection as the next elements
 that the receiver can access.  Returns aCollection.  The receiver's collection
 must be a type of String."

"Used in the implementation of PassiveObject."

position == (itsCollection size + 1)
ifFalse:
  [ ^ super nextPutAllBytes: aCharacterCollection ].
itsCollection addAllBytes: aCharacterCollection.
position := position + (aCharacterCollection _basicSize).
^ aCharacterCollection

]

{ #category : 'Adding' }
WriteStreamLegacy >> print: anObject [

	anObject printOn: self.

]

{ #category : 'Character writing' }
WriteStreamLegacy >> space: anInteger [
"Append anInteger space characters to the receiver."

anInteger timesRepeat: [ self nextPut: $   ]

]

{ #category : 'Character writing' }
WriteStreamLegacy >> tab: anInteger [
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [self nextPut: Tab ]

]
