Extension { #name : 'GsNMethod' }

{ #category : 'Traits' }
GsNMethod >> isFromTrait [

	^self origin isTrait
]

{ #category : 'Traits' }
GsNMethod >> origin [
	"If the receiver is a trait method, answer the Trait instance that created the method.
		If the method is a loaded method, answer the Rowan loaded method instance.
		Otherwise answer the class of the method"

	^ self _origin ifNil: [ ^ self inClass ]
]

{ #category : 'Accessing' }
GsNMethod >> _sourceStringWithLineNumbersWithOrigin [
 "Return source string with lines prefixed with line numbers, followed by source origin string (Class, Trait, or Rowan).
  Used by topaz."
 | sStr  |
 sStr := self _sourceStringWithLineNumbers .
^[
	| res originString |
	res := sStr.
	(originString := self _sourceOriginString) size > 0 ifTrue:[ | lf |
		lf := Character lf .
		res := res copy .
		(res at: res size) == lf ifFalse:[ res add: lf ].
		res add: originString .
	      ].
	res ] onException: Error do: [:ex |  sStr ].
]

{ #category : 'Accessing' }
GsNMethod >> _sourceStringWithOrigin [
 "Return source string with method origin appended ... A method origin may be a Class (no display), a Trait, or a Rowan loaded method."

  | sStr |
  sStr := self sourceString .
  ^ [ | res flStr |
      res := sStr .
      (flStr := self _sourceOriginString) size > 0 ifTrue:[ | lf |
	lf := Character lf .
	res := res copy .
	(res at: res size) == lf ifFalse:[ res add: lf ].
	res add: flStr .
      ].
      res
    ] onException: Error do:[:ex | sStr ]
]

