"
The Canonical Object Framework provides an optional way to reduce
duplicate instances of equivalent objects in your application. To accomplish
this goal you register a class as being canonicalizable (#'createRegistryFor:')
and then you can request a canonical object (#'canonicalObjectFor:'). 

To avoid commit conflicts, if a canonical object is not yet in the registry, the 
framework allows overlapping transactions to see different objects as the 
canonical one, but subsequent transactions will see one of the earlier ones.
To ensure that only one object is used, send #'ultimateCanonicalObjectFor:'
and be prepared to handle commit conflicts.

An alternate way to canonicalize objects is to provide a set of objects to the
manager and have it scan them for references to canonicalizable objects
(#'cleanupAll:'). This would typically be used with objects found using a
repository scan (Repository>>#'listReferencesToInstancesOfClasses:toDirectory:').

Because some objects should not have references arbitrarily replaced (e.g., 
IdentitySets), the framework uses a pluggable policy to decide which
referencing objects can be modified. The default ReferencingObjectPolicy 
bases the decision on the referencing object class.

A special case of object cleanup is #'cleanupWriteSet' that scans the write
set for the current transaction and replaces references as indicated by the
policy. Thus, a properly configured manager could do appropriate cleanup 
before a commit.

By default, the default instance of CanonicalObjectManager has world write 
permission so that canonical objects can be created by any session and shared.
You can modify this using CanonicalObjectManager class>>#securityPolicy:
"
Class {
	#name : 'CanonicalObjectManager',
	#superclass : 'Object',
	#instVars : [
		'referencingObjectPolicy',
		'registries',
		'sessionCacheStatOffset'
	],
	#classInstVars : [
		'default',
		'securityPolicy'
	],
	#category : 'Canonicalization'
}
