"
CanonicalObjectRegistry is internal to the Canonical Object Framework.
There may be one registry for each ClassHistory and it holds a collection 
(a KeyValueDictionary) of the ultimate canonical objects and a collection 
of potentialCanonicalObjects (an RcIdentityBag). If an equivalent object 
is not found in the registry, then the framework scans the potentials for
an equivalent object (which could have been added by any session). If
an equivalent object is found it is returned; otherwise the new object is
added to the potentials and returned.

At some time when conflicts are considered unlikely, one can send 
#'canonicalizePotentialCanonicalObjects' to the CanonicalObjectManager 
and the potentials will be added to the registry (improving subsequent
lookup performance).
"
Class {
	#name : 'CanonicalObjectRegistry',
	#superclass : 'Object',
	#instVars : [
		'canonicalObjectPolicy',
		'manager',
		'potentialCanonicalObjects',
		'registry'
	],
	#category : 'Canonicalization'
}
