"
GsOptionalPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.
"
Class {
	#name : 'GsOptionalPathTerm',
	#superclass : 'GsPathTerm',
	#category : 'Btree-PathTerm-Core'
}

{ #category : 'Private' }
GsOptionalPathTerm >> _findAllValuesForIdenticalRootObject: rootObject [
	" if index directly on NSC elements or anObject is nil "

	| ivOffset |
	ivOffset := self _ivOffsetFor: rootObject.
	ivOffset
		ifNil: [ 
			"no values in index for rootObject"
			^ IdentityBag new ].
	^ super _findAllValuesForIdenticalRootObject: rootObject
]

{ #category : 'Accessing' }
GsOptionalPathTerm >> _nextObjectFor: anObject atInstVar: anIvOffset [
	"Returns the object at the instance variable that corresponds to the receiver
 path term."

	| ivOffset |
	ivOffset := self _ivOffsetFor: anObject.
	ivOffset ifNil: [ ^ nil ].
	^ super _nextObjectFor: anObject atInstVar: anIvOffset
]

{ #category : 'Adding' }
GsOptionalPathTerm >> addMappingsForObject: anObject root: rootObject logging: aBoolean [
	"Add dependency list entries for anObject."

	| ivOffset |
	(nil == anObject or: [ self size == 0 ])
		ifTrue: [ ^ self ].
	(ivOffset := self _ivOffsetFor: anObject) == nil
		ifTrue: [ ^ self recordNilOnPathForRoot: rootObject ].
	^ super addMappingsForObject: anObject root: rootObject logging: aBoolean
]

{ #category : 'Adding' }
GsOptionalPathTerm >> removeMappingsFor: anObject root: rootObject lastOne: aBoolean logging: doLogging [
  "Remove entries in the btree and dependency lists for anObject."

	| ivOffset |
	(nil == anObject or: [ self size == 0 ])
		ifTrue: [ ^ self ].
	(ivOffset := self _ivOffsetFor: anObject) == nil
		ifTrue: [ ^ self removeNilOnPathForRoot: rootObject ].
	^ super removeMappingsFor: anObject root: rootObject lastOne: aBoolean logging: doLogging
]
