"
GsPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.
"
Class {
	#name : 'GsPathTerm',
	#superclass : 'Array',
	#instVars : [
		'name',
		'offset',
		'securityPolicies',
		'children',
		'updateBtree',
		'needsDepList',
		'requirePathTerms',
		'termsRequired',
		'nilOnPath'
	],
	#category : 'Btree-PathTerm-Core'
}

{ #category : 'Private' }
GsPathTerm >> _findAllValuesForIdenticalRootObject: rootObject [
	" if index directly on NSC elements or anObject is nil "

	| key tmpList |
	(self indicatesIndexOnNscElements or: [ nil == rootObject ])
		ifTrue: [ key := rootObject ]
		ifFalse: [ key := self _nextObjectFor: rootObject ].
	tmpList := IdentityBag new.
	self updateBtree btreeRoot _findAllValuesForIdenticalKey: key into: tmpList.
	^ (tmpList occurrencesOf: rootObject) <= 1
]
