"
GsSingleRefPathFinder is a class used to determine how each object in a list
are connected to the repository.  It is typically used to determine why objects
expected to be collected by global garbage collection (markForCollection) were
not removed.  The list of objects connecting an object to the repository is
called a reference path.  An object may have more than one reference path,
however this class only determines one reference path for every search object.

Instance Variables:

searchObjects - a GsBitmap containing all objects for which reference paths will
be searched.

limitObjects - an array of GsBitmaps.  The first element contains the base limit
set of the search, that is, a group of objects known to be
connected to the repository.  The base limit set is returned by
the method SystemRepository buildLimitSetForRefPathScan.  The
next element in the array are the children of the based limit
set, and the next are the grandchildren, etc.

allSearches - anArray containing instances of GsSingleRefPathFinderForObject.  One
instance for each search object.

numSearchesActive - number of searches not yet completed.

otScanDone - Boolean indicating if the object table scan has been completed.
This is the first phase of the scan and only runs once.

printToLog - Boolean indicating if messages and results are to be written to
stdout of the process.

scanStartTime - A SmallInteger representing the timestamp of when the scan
started.

opStartTime - A SmallInteger - representing the timestamp of when an operation
started.  Used to print elapsed times to the log.

maxThreads - number of threads to use to perform the scan.

lockWaitTime - number of seconds to wait when acquiring the garbage collection
lock before starting the scan.

pageBufferSize - number of 16 KB pages each thread will buffer.  Must be a power
of 2.

percentCpuLimit - percentage of total system CPU which the scan may consume.

maxLimitSetDescendantObjs - maximum size of a generation of objects reachable
from the limit set.  At the beginning of the scan, the default limit set is
traversed until the size of the generation exceeds this value.  Default is
one million objects.

maxLimitSetDescendantLevels - maximum number of generations traversed to build
the limit set.  At the beginning of the scan, the default limit set is
traversed until the number of generations searched this value.  Default is 
unlimited.

Steps to find a reference path:

1) Create an instance with default settings:
| inst |
inst := GsSingleRefPathFinder newForSearchObjects: (Array with: mySearchObject)

2) Run the scan
inst runScan

3) Build the result objects (An Array of GsSingleRefPathResult objects)
inst buildResultObjects

The GsSingleRefPathResult object is the equivalent of the structured Array 
returned by findReferencePathToObj* methods in earlier releases.

4) For display, collect the results as strings:
<resultObjs> collect: [:e | e resultString]

For example:

| inst |
inst := GsSingleRefPathFinder newForSearchObjects: { myObj }.
inst runScan.
(inst buildResultObjects) 
   collect: [:e | e resultString]

Steps 2-4 can be done using inst scanAndReport. For example:

(GsSingleRefPathFinder newForSearchObjects: { myObj }) scanAndReport

"
Class {
	#name : 'GsSingleRefPathFinder',
	#superclass : 'Object',
	#instVars : [
		'searchObjects',
		'limitObjects',
		'allSearches',
		'numSearchesActive',
		'numPassesDone',
		'otScanDone',
		'printToLog',
		'scanStartTime',
		'opStartTime',
		'maxThreads',
		'lockWaitTime',
		'pageBufferSize',
		'percentCpuLimit',
		'maxLimitSetDescendantObjs',
		'maxLimitSetDescendantLevels'
	],
	#category : nil
}
