"
Instances of Int64Array are byte format arrays that store 64 bit signed integers.
For an instance loaded into memory, the integers are in machine native byte order.
"
Class {
	#name : 'Int64Array',
	#superclass : 'Uint64Array',
	#gs_options : [
		'signed8byteWords'
	],
	#category : nil
}

{ #category : 'Updating' }
Int64Array >> at: anOffset put: aValue [

"aValue must be an Integer representable as a 64bit unsigned integer.
 returns aValue ."

<primitive: 1077>
| max min |
aValue _validateClass: Integer .
max := 16r7FFFFFFFFFFFFFFF .
min := -9223372036854775808 .
(aValue < min or:[ aValue > max ]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ min . max }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #codePointAt:put: args: { anOffset . aValue }

]

