"
AppendableString is intended for streams that are are created empty,  
appended to , and then the contents are retrieved for writing to a socket.
There is no stream-specific support for reading, write limit, nor 
position logic.
Takes advantage of the fact that Strings in GemStone are variable size. 

Instance creation is inherited from   String class >> new .

The contents of a AppendableString are 
Characters with codePoints in range 0 to 255, or UTF8 encoded data .
Attempts to append codePoints above 255 with nextPut methods 
will signal an error.
"
Class {
	#name : 'AppendableString',
	#superclass : 'String',
	#category : nil
}

{ #category : 'Instance Creation' }
AppendableString class >> new: aSize [
  "Disallowed,  use the inherited   String class >> new ."
  self shouldNotImplement: #new:

]

{ #category : 'Updating' }
AppendableString >> _reverseFrom: aString [
"Disallowed"
  self shouldNotImplement: #_reverseFrom:

]

{ #category : 'Adding' }
AppendableString >> add: aCharacterOrString [
  <primitive: 296>
  ^ self nextPutAll: aCharacterOrString

]

{ #category : 'Adding' }
AppendableString >> addAll: aString [
  <primitive: 296>
  ^ self nextPutAll: aString

]

{ #category : 'Adding' }
AppendableString >> addCodePoint: aSmallInteger [
  <primitive: 1047>
  ^ self nextPut: (Character codePoint: aSmallInteger).

]

{ #category : 'Adding' }
AppendableString >> addLast: aCharacterOrString [
  <primitive: 296>
  ^ self nextPutAll: aCharacterOrString

]

{ #category : 'Updating' }
AppendableString >> at: anIndex put: aChar [

anIndex == (self size + 1) ifTrue:[
  ^ self add: aChar .
].
^ self _errorIndexOutOfRange: anIndex

]

{ #category : 'Updating' }
AppendableString >> codePointAt: anIndex put: aSmallInteger [

anIndex == (self size + 1) ifTrue:[
  ^ self addCodePoint: aSmallInteger .
].
^ self _errorIndexOutOfRange: anIndex

]

{ #category : 'Accessing' }
AppendableString >> contents [
  ^ self

]

{ #category : 'Character writing' }
AppendableString >> cr [
  self addCodePoint: 13

]

{ #category : 'Character writing' }
AppendableString >> crlf [
  self addCodePoint: 13 ; addCodePoint: 10

]

{ #category : 'Character writing' }
AppendableString >> crtab [
  self addCodePoint: 13 ; addCodePoint: 9

]

{ #category : 'Character writing' }
AppendableString >> crtab: anInteger [
  "Append a return character, followed by anInteger tab characters, to the
  receiver."

  self addCodePoint: 13 .
  anInteger timesRepeat: [ self addCodePoint: 9 ]

]

{ #category : 'Updating' }
AppendableString >> insertAll: aCharOrCharColl at: anIndex [

anIndex == (self size + 1) ifTrue:[
  ^ self addAll: aCharOrCharColl
].
^ self _errorIndexOutOfRange: anIndex

]

{ #category : 'Adding' }
AppendableString >> nextPut: aCharacterOrString [
  <primitive: 296>
  ^ self nextPutAll: aCharacterOrString

]

{ #category : 'Adding' }
AppendableString >> nextPutAll: aCharacterOrString [
  <primitive: 296>
  aCharacterOrString class == Character ifTrue:[
    aCharacterOrString codePoint > 255 ifTrue:[
      ArgumentError signal:'codePoint exceeds 255'.
    ].
  ].
  aCharacterOrString stringCharSize == 1 ifFalse:[
    aCharacterOrString _validateKindOfClass: String .
  ].
  ^ self _primitiveFailed: #nextPutAll: args: { aCharacterOrString }.

]

{ #category : 'Encoding' }
AppendableString >> nextPutAllUtf8: aCharacterOrString [
 "Appends the UTF8 encoding of the argument to receiver"
 <primitive: 1045>
  aCharacterOrString _validateKindOfClasses: { Character . String } .
  ^ self _primitiveFailed: #nextPutAllUtf8: args: { aCharacterOrString }

]

{ #category : 'Adding' }
AppendableString >> nextPutCodePoint: aSmallInteger [
  <primitive: 1047>
  ^ self nextPut: (Character codePoint: aSmallInteger).

]

{ #category : 'Updating' }
AppendableString >> removeFrom: startIndex to: stopIndex [

"Disallowed"
  self shouldNotImplement: #removeFrom:to:

]

{ #category : 'Updating' }
AppendableString >> size: anInteger [

anInteger == 0 ifFalse:[
  Error signal:' size: should only be used to reset a stream to empty'
].
^super size: anInteger

]

{ #category : 'Character writing' }
AppendableString >> space [
  self addCodePoint: 32

]

{ #category : 'Character writing' }
AppendableString >> space: anInteger [
  "Append anInteger space characters to the receiver."

  anInteger timesRepeat: [ self addCodePoint: 32 ]

]

{ #category : 'Character writing' }
AppendableString >> tab [
  self addCodePoint: 9

]

{ #category : 'Character writing' }
AppendableString >> tab: anInteger [
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [self tab]

]
