Extension { #name : 'BagUnicodeEnumerator' }

{ #category : 'accessing' }
BagUnicodeEnumerator >> compareEqual [
  selector := #'_idxForCompareEqualTo:collator:'

]

{ #category : 'accessing' }
BagUnicodeEnumerator >> compareGreaterThan [
  selector := #'_idxForCompareGreaterThan:collator:'

]

{ #category : 'accessing' }
BagUnicodeEnumerator >> compareGreaterThanOrEqual [
  selector := #'_idxForCompareGreaterThanOrEqualTo:collator:'

]

{ #category : 'accessing' }
BagUnicodeEnumerator >> compareIdentical [
  "use BagEnumerator for identity comparisons"

  self shouldNotImplement: #'compareIdentical'

]

{ #category : 'accessing' }
BagUnicodeEnumerator >> compareLessThan [
  selector := #'_idxForCompareLessThan:collator:'

]

{ #category : 'accessing' }
BagUnicodeEnumerator >> compareLessThanOrEqual [
  selector := #'_idxForCompareLessThanOrEqualTo:collator:'

]

{ #category : 'accessing' }
BagUnicodeEnumerator >> compareNotEqual [
  selector := #'_idxForCompareNotEqualTo:collator:'

]

{ #category : 'accessing' }
BagUnicodeEnumerator >> compareNotIdentical [
  "use BagEnumerator for identity comparisons"

  self shouldNotImplement: #'compareNotIdentical'

]

{ #category : 'accessing' }
BagUnicodeEnumerator >> evaluator: anEvaluator [
  super evaluator: anEvaluator.
  collator := anEvaluator collator

]

{ #category : 'testing' }
BagUnicodeEnumerator >> value: aValue and: ignored test: endObj [
  ^ endObj perform: selector with: aValue with: collator

]
