Extension { #name : 'BlockSorter' }

{ #category : 'Instance Creation' }
BlockSorter class >> on: anNsc with: sortBlock [

^ self on: anNsc with: sortBlock collator: nil

]

{ #category : 'Instance Creation' }
BlockSorter class >> on: anNsc with: sortBlock collator: anIcuCollator [

 "Returns an initialized instance of BlockSorter.

 To use BlockSorter explicitly outside of the indexing subsystem,
 the recommended way is to send  sortWithBlock:  or  sortWithBlock:persistentRoot:
 to a kind of Collection."

| inst sortNode  |
inst := self new.
inst sortBlock: sortBlock collator: anIcuCollator .
sortNode := inst sortNodeClassForSort new: anNsc size.
sortNode blockSorter: inst.

inst sortNodes: (SortNodeArray with: sortNode).
^ inst

]

{ #category : 'Updating' }
BlockSorter >> _addObject: anObject
inNodes: nodeArray [

  | lastNode |
    lastNode := nodeArray at: nodeArray size.
    " if the last sort node is full, create a new one "
    lastNode isFull
      ifTrue: [
        lastNode := lastNode class new: lastNode numElements.
        lastNode blockSorter: self.
        nodeArray add: lastNode
      ].
  " add an entry to the sort node "
  lastNode _at: anObject
    put: anObject
    forBtree: false

]

{ #category : 'Accessing' }
BlockSorter >> sortBlock [

^sortBlock

]

{ #category : 'Updating' }
BlockSorter >> sortBlock: aBlock [

sortBlock := aBlock

]

{ #category : 'Updating' }
BlockSorter >> sortBlock: aBlock  collator: anIcuCollator [

sortBlock := aBlock .
anIcuCollator ifNotNil:[
  self dynamicInstVarAt: #collator put: anIcuCollator .
].

]

{ #category : 'Private' }
BlockSorter >> sortInto: anArray startingAt: index [

"Returns anArray filled with objects that have been added to the receiver, in
 sorted order."
sortNodes size == 1
  ifTrue: [ (sortNodes at: 1) sortInto: anArray startingAt: index ]
  ifFalse: [
    sortNodes size == 2
      ifTrue: [ sortNodes binaryMergeAscendingInto: anArray startingAt: index  ]
      ifFalse: [  sortNodes nwayMergeAscendingInto: anArray startingAt: index ].
  ].
^ anArray

]

{ #category : 'Accessing' }
BlockSorter >> sortNodeClassForSort [

"Returns the class of SortBlockNode to use."
^ (self dynamicInstVarAt: #collator)
    ifNil:[  SortBlockNode ]
    ifNotNil:[ SortBlockUnicodeNode ]

]

{ #category : 'Accessing' }
BlockSorter >> sortNodes [

"Returns the value of the instance variable 'sortNodes'."

^sortNodes

]

{ #category : 'Updating' }
BlockSorter >> sortNodes: anArray [

sortNodes := anArray

]
