Extension { #name : 'BtreeBasicLeafNode' }

{ #category : 'Constants' }
BtreeBasicLeafNode class >> entrySize [

"Returns the size of an entry (with 2 slots for encryption)."

^ 4

]

{ #category : 'Constants' }
BtreeBasicLeafNode class >> maxNumberOfElements [

"Returns the number of entries that are allowed in a leaf node."

^ 500

]

{ #category : 'Query Support' }
BtreeBasicLeafNode >> _addValues: aQuerySpec
start: startIndex
end: endIndex
into: collection [

<primitive: 555>

^super
    _addValues: aQuerySpec
    start: startIndex
    end: endIndex
    into: collection

]

{ #category : 'Searching' }
BtreeBasicLeafNode >> _binarySearchCoveringKey: aKey totalOrder: aBoolean [

"Returns the index for the first entry in which aKey is found utilizing a
 binary search.  This is the first entry whose key >= aKey."

<primitive: 114>
self _primitiveFailed: #_binarySearchCoveringKey:totalOrder:
     args: { aKey . aBoolean }.
self _uncontinuableError

]

{ #category : 'Searching' }
BtreeBasicLeafNode >> _binarySearchCoveringKey: aKey value: aValue [

"Returns the index for the entry in which aKey/aValue would be inserted.  This
 is the first entry which has its key >= aKey.  If multiple entries have the
 same key (key = aKey), then aValue is used (since entries with duplicate keys
 are inserted by the value's OOP ordering).  If the receiver is empty, returns
 1.  Uses a binary search."

<primitive: 112>
self _primitiveFailed: #_binarySearchCoveringKey:value:
     args: { aKey . aValue }.
self _uncontinuableError

]

{ #category : 'Searching' }
BtreeBasicLeafNode >> _binarySearchForKey: aKey value: aValue [

"Returns the 'value' index whose key equality matches aKey.  If no match is
 found, returns zero.  Uses a binary search."

<primitive: 113>
self _primitiveFailed: #_binarySearchForKey:value:
     args: { aKey . aValue }.
self _uncontinuableError

]

{ #category : 'Testing' }
BtreeBasicLeafNode >> _canCompare: aKey withClass: aClass [

"Returns whether the receiver can make comparisons with the given key."

^ self _basicCanCompare: aKey withClass: aClass

]

{ #category : 'Comparison Operators' }
BtreeBasicLeafNode >> _compareKey: aKey equalToEntryAt: index [

"Performs an equality comparison between aKey and the entry whose key is at the
 given index.  Use encryption to make the comparison faster."

<primitive: 160>
self _primitiveFailed: #_compareKey:equalToEntryAt:
     args: { aKey . index }.
self _uncontinuableError

]

{ #category : 'Audit' }
BtreeBasicLeafNode >> _encryptionFor: aKey [

"Get the encryption for the given value and return it
 in a 2 slot Array."

<primitive: 871>
self _primitiveFailed: #_encryptionFor: args: { aKey }

]

{ #category : 'Constants' }
BtreeBasicLeafNode >> _encryptionSize [

"Two slots are used for encryption."

^ 2

]

{ #category : 'Searching' }
BtreeBasicLeafNode >> _findAllValuesForIdenticalKey: aKey into: aCollection using: aComparison [
  "Finds all the values for the given identical key, placing them in the
 collection.  For leaf nodes, must first find the appropriate entry, then
 iterate through successive entries until we reach the end or a key does
 not match.  Return whether the last key was equal or not (so the caller
 knows it must check the next leaf node)."

  | index maxIndex querySpec class querySpecClass |
  " find first entry that might contain the key"
  index := self _findCoveringIndexForKey: aKey totalOrder: false.
  index == 0
    ifTrue: [ ^ false ].
  maxIndex := self _lastIndex.
  querySpecClass := self collator
    ifNil: [ BtreeComparisonQuerySpec ]
    ifNotNil: [ BtreeUnicodeComparisonQuerySpec ].
  querySpec := querySpecClass key: aKey selector: #'=='.
  querySpec collator: self collator.
  class := aCollection class.
  (class == Array or: [ class == NscBuilder ])
    ifTrue: [
      querySpec
        addValuesFrom: self
        start: index
        end: maxIndex
        into: aCollection ]
    ifFalse: [
      | ar |
      ar := {}.
      querySpec
        addValuesFrom: self
        start: index
        end: maxIndex
        into: ar.
      aCollection addAll: ar ].
  ^ self _compare: aComparison key: aKey equalToEntryAt: maxIndex - 4 + 2

]

{ #category : 'Updating' }
BtreeBasicLeafNode >> _insertEncryptionFor: aKey value: aValue startingAt: index [

"Gets the encryption for the given value and places it in the receiver starting
 at the given index."

<primitive: 373>
self _primitiveFailed: #_insertEncryptionFor:value:startingAt:
     args: { aKey . aValue . index }.
self _uncontinuableError

]

{ #category : 'Accessing' }
BtreeBasicLeafNode >> _lastIndex [

"Returns the index of the last used slot in the node."

^ numElements * 4

]

{ #category : 'Accessing' }
BtreeBasicLeafNode >> _lastKeyIndex [

"Returns the index of the key of the last entry, or zero if the node is empty."

^ numElements == 0
    ifTrue: [ 0 ]
    ifFalse: [ numElements * 4 - 2 ]

]

{ #category : 'Query Support' }
BtreeBasicLeafNode >> _traverseValues: aQuerySpec
start: startIndex
end: endIndex
previous: previousValue
into: collection [

<primitive: 588>

^ super
    _traverseValues: aQuerySpec
    start: startIndex
    end: endIndex
    previous: previousValue
    into: collection

]

{ #category : 'Constants' }
BtreeBasicLeafNode >> entrySize [

"Returns the size of an entry (with 2 slots for encryption)."

^ 4

]

{ #category : 'Constants' }
BtreeBasicLeafNode >> mergeThreshold [

"Returns the threshold such that if an entry has less than this number, it must
 have elements added from its sibling or be merged with its sibling.  This
 value is usually the same as the result of the message
 'self maxNumberOfElements quo: 2'."

^ 250

]

{ #category : 'Constants' }
BtreeBasicLeafNode >> parentNodeClass [

"Returns the class of node to be created as the parent when a split occurs."

^ BtreeBasicInteriorNode

]
