Extension { #name : 'BtreeComparisonForCompare' }

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare class >> compareKey: aKey equalTo: aValue [

^ aKey _idxForCompareEqualTo: aValue

]

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare class >> compareKey: aKey greaterThan: aValue [

^ aKey _idxForCompareGreaterThan: aValue

]

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare class >> compareKey: aKey greaterThanOrEqualTo: aValue [

^ aKey _idxForCompareGreaterThanOrEqualTo: aValue

]

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare class >> compareKey: aKey lessThan: aValue [

^ aKey _idxForCompareLessThan: aValue

]

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare class >> compareKey: aKey lessThanOrEqualTo: aValue [

^ aKey _idxForCompareLessThanOrEqualTo: aValue

]

{ #category : 'instance creation' }
BtreeComparisonForCompare class >> newForComparison [
  ^ self new

]

{ #category : 'instance creation' }
BtreeComparisonForCompare class >> newForComparison: aCollatorOrNil [
  ^ aCollatorOrNil
    ifNil: [ self new ]
    ifNotNil: [ :collator |
      BtreeComparisonForUnicodeCompare new
        collator: collator;
        yourself ]

]

{ #category : 'instance creation' }
BtreeComparisonForCompare class >> newForSort [
  ^ BtreeComparisonForSort new

]

{ #category : 'instance creation' }
BtreeComparisonForCompare class >> newForSort: aCollatorOrNil [
  ^ aCollatorOrNil
    ifNil: [ BtreeComparisonForSort new ]
    ifNotNil: [ :collator |
      BtreeComparisonForUnicodeSort new
        collator: collator;
        yourself ]

]

{ #category : 'Testing' }
BtreeComparisonForCompare class >> satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2 [
  ^ ((val1 _idxForCompareGreaterThan: val2)
    or: [ (val1 _idxForCompareEqualTo: val2) and: [ (bool1 and: [ bool2 ]) not ] ])
    not

]

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare >> compareKey: aKey equalTo: aValue [

^ aKey _idxForCompareEqualTo: aValue

]

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare >> compareKey: aKey greaterThan: aValue [

^ aKey _idxForCompareGreaterThan: aValue

]

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare >> compareKey: aKey greaterThanOrEqualTo: aValue [

^ aKey _idxForCompareGreaterThanOrEqualTo: aValue

]

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare >> compareKey: aKey lessThan: aValue [

^ aKey _idxForCompareLessThan: aValue

]

{ #category : 'Comparison Operators' }
BtreeComparisonForCompare >> compareKey: aKey lessThanOrEqualTo: aValue [

^ aKey _idxForCompareLessThanOrEqualTo: aValue

]

{ #category : 'Testing' }
BtreeComparisonForCompare >> satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2 [
  ^ ((val1 _idxForCompareGreaterThan: val2)
    or: [ (val1 _idxForCompareEqualTo: val2) and: [ (bool1 and: [ bool2 ]) not ] ])
    not

]
