Extension { #name : 'BtreeComparisonForIdentity' }

{ #category : 'Instance Creation' }
BtreeComparisonForIdentity class >> newForSort [
  ^ self new

]

{ #category : 'Comparison Operators' }
BtreeComparisonForIdentity >> compareKey: aKey equalTo: aValue [
  ^ aKey == aValue

]

{ #category : 'Comparison Operators' }
BtreeComparisonForIdentity >> compareKey: aKey greaterThan: aValue [
  ^ aKey asOop > aValue asOop

]

{ #category : 'Comparison Operators' }
BtreeComparisonForIdentity >> compareKey: aKey greaterThanOrEqualTo: aValue [
  ^ aKey asOop >= aValue asOop

]

{ #category : 'Comparison Operators' }
BtreeComparisonForIdentity >> compareKey: aKey lessThan: aValue [
  ^ aKey asOop < aValue asOop

]

{ #category : 'Comparison Operators' }
BtreeComparisonForIdentity >> compareKey: aKey lessThanOrEqualTo: aValue [
  ^ aKey asOop <= aValue asOop

]

{ #category : 'Testing' }
BtreeComparisonForIdentity >> satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2 [

  ^ ((val1 _idxForCompareGreaterThan: val2)
    or: [ (val1 _idxForSortEqualTo: val2) and: [ (bool1 and: [ bool2 ]) not ] ])
    not

]
