Extension { #name : 'BtreeOptimizedUnicodeComparison' }

{ #category : 'initialization' }
BtreeOptimizedUnicodeComparison >> collator: anIcuCollator [
  collator := anIcuCollator

]

{ #category : 'Comparison Operators' }
BtreeOptimizedUnicodeComparison >> compareKey: aKey equalTo: aValue [
  ^ aKey _equals: aValue collator: collator useMinSize: 900

]

{ #category : 'Comparison Operators' }
BtreeOptimizedUnicodeComparison >> compareKey: aKey greaterThan: aValue [
  ^ (aKey compareTo: aValue collator: collator useMinSize: 900) > 0

]

{ #category : 'Comparison Operators' }
BtreeOptimizedUnicodeComparison >> compareKey: aKey greaterThanOrEqualTo: aValue [
  ^ (self compareKey: aKey lessThan: aValue) not

]

{ #category : 'Comparison Operators' }
BtreeOptimizedUnicodeComparison >> compareKey: aKey lessThan: aValue [
  ^ (aKey compareTo: aValue collator: nil useMinSize: 900) < 0

]

{ #category : 'Comparison Operators' }
BtreeOptimizedUnicodeComparison >> compareKey: aKey lessThanOrEqualTo: aValue [
  ^ (self compareKey: aKey greaterThan: aValue) not

]

{ #category : 'Testing' }
BtreeOptimizedUnicodeComparison >> satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2 [

  ^ (val1 isNil or: [ val2 isNil ])
    ifTrue: [
      ((val1 _idxForCompareGreaterThan: val2)
        or: [ (val1 _idxForCompareEqualTo: val2) and: [ (bool1 and: [ bool2 ]) not ] ]) not ]
    ifFalse: [
      ((self compareKey: val1 greaterThan: val2)
        or: [
          (self compareKey: val1 equalTo: val2)
            and: [ (bool1 and: [ bool2 ]) not ] ]) not ]

]
