Extension { #name : 'BtreePlusNodeAuditor' }

{ #category : 'Audit' }
BtreePlusNodeAuditor class >> checkDebug: auditResultString [ 
  (SessionTemps current at: #GsDebugIndexing otherwise: false) ifTrue:[
     System waitForDebug .
  ].
]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> auditInfoFor: pathTerm info: array [
  | obj indexObj depList pathTermName |
  pathTerm size == 0
    ifTrue: [ ^ self ].
  obj := array at: 1.
  indexObj := array at: 2.
  depList := array at: 3.
  auditResultString add: 'object'.
  (obj isKindOf: CharacterCollection)
    ifTrue: [ auditResultString
        add: Character space;
        add: obj ].
  auditResultString
    add: ' [';
    add: obj asOop asString;
    add: '] of class ';
    add: obj class asString.
  indexObj ~~ nil
    ifTrue: [ auditResultString
        add: ', ';
        add: (indexObj isRangeEqualityIndex
                ifTrue: [ 'equality' ]
                ifFalse: [ 'identity' ]);
        add: ' index <';
        add: indexObj pathComponentsString;
        add: '> [';
        add: indexObj asOop asString;
        add: ']' ].
  auditResultString
    add: ', path term <';
    add: pathTerm name.
  (pathTermName := pathTerm name) == #'*'
    ifTrue: [ auditResultString add: ' offset: ' , pathTerm offset asString ].
  auditResultString
    add: '> [';
    add: pathTerm asOop asString;
    add: ']'.
  depList ~~ nil
    ifTrue: [ auditResultString
        add: ', depList [';
        add: depList asOop asString;
        add: ']' ].
  auditResultString
    add:
      '
    -- ' .
  self checkDebug

]

{ #category : 'accessing' }
BtreePlusNodeAuditor >> auditResultString [

   ^auditResultString

]

{ #category : 'accessing' }
BtreePlusNodeAuditor >> auditResultString: anObject [

   auditResultString := anObject

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree incorrectCountForKeyValueRootPairs: pathTerm key: k value: v  root: r found: foundCount expected: expectedCount [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has incorrect count for key/value/root tuple; key ';
    add: k printString printString;
    add: ' [';
    add: k asOop asString;
    add: '] value ';
    add: v printString printString;
    add: ' [';
    add: v asOop asString;
    add: '] root ';
    add: r printString printString;
    add: ' [';
    add: r asOop asString;
    add: ']. Found ';
    add: foundCount printString ;
    add: ' occurences and expected ';
    add: expectedCount printString;
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree incorrectKey: pathTerm key: k value: v expectedKey: expectedKey ivOffset: ivOffset [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has entry for [';
    add: v asOop asString;
    add: '] of class ';
    add: v class asString;
    add: ' associated with incorrect key [';
    add: k asOop asString;
    add: '] expected value is ( ';
    add: expectedKey asOop asString;
    add: '). The key should be identical to the instance variable at offset ( ';
    add: ivOffset asString;
    add: ') in [';
    add: v asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree incorrectKeyForEnumeratedPathTerm: pathTerm key: k value: v expectedKey: expectedKey selector: selector [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has entry for [';
    add: v asOop asString;
    add: '] of class ';
    add: v class asString;
    add: ' associated with incorrect key [';
    add: k asOop asString;
    add: '] expected value is ( ';
    add: expectedKey asOop asString;
    add: '). The key should sort equal to the value returned by the selector #';
    add: selector asString;
    add: ' when sent to [';
    add: v asOop asString;
    add: ']';
    add: Character lf.
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree incorrectNumberOfEntries: pathTerm key: k value: v bag: bag numExpected: numExpected [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has incorrect number of entries (';
    add: bag size asString;
    add: ') for [';
    add: v asOop asString;
    add: '] of class ';
    add: v class asString;
    add: ' (should be ';
    add: numExpected asString;
    add: ')';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree mismatchedKeyAndValueForIndexOnNscElements: pathTerm key: k value: v [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has entry for [';
    add: v asOop asString;
    add: '] of class ';
    add: v class asString;
    add: ' associated with incorrect key [';
    add: k asOop asString;
    add: '] should be ( ';
    add: v asOop asString;
    add: '). Key and value should be identical.';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree mismatchedRootAndValueForIndexOnNscElements: pathTerm key: k value: v root: r [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has entry for [';
    add: v asOop asString;
    add: '] of class ';
    add: v class asString;
    add: ' associated with incorrect root object [';
    add: r asOop asString;
    add: '] should be ( ';
    add: v asOop asString;
    add: ') ';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree outOfOrderKeys: pathTerm key: k previous: previousKey [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has key ';
    add: k printString printString;
    add: ' out of order [';
    add: k asOop asString;
    add: '] that sorts greater than previous key';
    add: previousKey printString printString;
    add: ' [';
    add: previousKey asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree outOfOrderKeyValuePairs: pathTerm key: k previous: previousKey value: v previous: previousValue [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has out of oop order key/value pairs where the key ';
    add: k printString printString;
    add: ' [';
    add: k asOop asString;
    add: '] is equal to previous key ';
    add: previousKey printString printString;
    add: ' [';
    add: previousKey asOop asString;
    add: '] but the oop of the value ';
    add: v printString printString;
    add: ' [';
    add: v asOop asString;
    add: '] is less than the oop of the previous value ';
    add: previousValue printString printString;
    add: ' [';
    add: previousValue asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree outOfOrderKeyValueRootPairs: pathTerm key: k previous: previousKey value: v previous: previousValue root: r previous: previousRoot [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has out of oop order key/value/root where the key ';
    add: k printString printString;
    add: ' [';
    add: k asOop asString;
    add: '] is equal to previous key ';
    add: previousKey printString printString;
    add: ' [';
    add: previousKey asOop asString;
    add: '] and oop of the value ';
    add: v printString printString;
    add: ' [';
    add: v asOop asString;
    add: '] is equal to the oop of the previous value ';
    add: previousValue printString printString;
    add: ' [';
    add: previousValue asOop asString;
    add: '] but the oop of the root ';
    add: r printString printString;
    add: ' [';
    add: r asOop asString;
    add: '] is less than the oop of the previous root ';
    add: previousRoot printString printString;
    add: ' [';
    add: previousRoot asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree parentNode: parentNode nextLeafMismatch: pathTerm nextLeaf: nextLeaf parentNextNode: nextNode [
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has a next leaf node [';
    add: nextLeaf asOop asString;
    add: '] of class ';
    add: nextLeaf class asString;
    add: ' that does not match the next leaf node [';
    add: nextNode asOop asString;
    add: '] that is expected by the parent node [';
    add: parentNode asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btree: btree parentNode: parentNode previousLeafMismatch: pathTerm previousLeaf: previousLeaf parentPreviousNode: previousNode [
  auditResultString
    add: 'Btree [';
    add: btree asOop asString;
    add: '] has a previous leaf node [';
    add: previousLeaf asOop asString;
    add: '] of class ';
    add: previousLeaf class asString;
    add: ' that does not match the previous leaf node [';
    add: previousNode asOop asString;
    add: '] that is expected by parent node [';
    add: parentNode asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btreeInteriorNode: btree childConsistencyError: pathTerm key: k lastChildKey: lastChildKey childNode: childNode index: index [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree interior node [';
    add: btree asOop asString;
    add: '] at index: ';
    add: index asString;
    add: ' has key ';
    add: k printString printString;
    add: ' [';
    add: k asOop asString;
    add: '] that does not match the last key ';
    add: lastChildKey printString printString;
    add: ' [';
    add: lastChildKey asOop asString;
    add: ' ] of the child node [';
    add: childNode asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btreeInteriorNode: btree childConsistencyError: pathTerm key: k root: r lastChildRoot: lastChildRoot childNode: childNode index: index [
  pathTerm auditInfo: {k.
      nil.
      nil} using: self.
  auditResultString
    add: 'Btree interior node [';
    add: btree asOop asString;
    add: '] at index: ';
    add: index asString;
    add: ' has root ';
    add: r printString printString;
    add: ' [';
    add: r asOop asString;
    add: '] that does not match the last root ';
    add: lastChildRoot printString printString;
    add: ' [';
    add: lastChildRoot asOop asString;
    add: ' ] of the child node [';
    add: childNode asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btreeInteriorNode: btree childConsistencyError: pathTerm lastRoot: lastRoot lastChildRoot: lastChildRoot childNode: childNode [
  auditResultString
    add: 'Btree interior node [';
    add: btree asOop asString;
    add: '] has lastRoot ';
    add: lastRoot printString printString;
    add: ' [';
    add: lastRoot asOop asString;
    add: '] that does not match the last child root ';
    add: lastChildRoot printString printString;
    add: ' [';
    add: lastChildRoot asOop asString;
    add: ' ] of the child node [';
    add: childNode asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btreeInteriorNode: btree childConsistencyError: pathTerm lastValue: lastValue lastChildValue: lastChildValue childNode: childNode [
  auditResultString
    add: 'Btree interior node [';
    add: btree asOop asString;
    add: ']  has lastValue ';
    add: lastValue printString printString;
    add: ' [';
    add: lastValue asOop asString;
    add: '] that does not match the last child value ';
    add: lastChildValue printString printString;
    add: ' [';
    add: lastChildValue asOop asString;
    add: '] of the child node [';
    add: childNode asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btreeInteriorNode: btree keyOrderError: pathTerm key: k previousKey: previousKey index: index [
  pathTerm
    auditInfo:
      {k.
      nil.
      nil}
    using: self.
  auditResultString
    add: 'Btree interior node [';
    add: btree asOop asString;
    add: '] at index: ';
    add: index asString;
    add: ' has key ';
    add: k printString printString;
    add: ' out of order [';
    add: k asOop asString;
    add: '] that sorts greater than previous key';
    add: previousKey printString printString;
    add: ' [';
    add: previousKey asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'btree audit failures' }
BtreePlusNodeAuditor >> btreeInteriorNodeKeyOrderError: pathTerm key: k previousKey: previousKey index: index [
  pathTerm
    auditInfo:
      {k.
      nil.
      nil}
    using: self.
  auditResultString
    add: 'Btree interior node [';
    add: self asOop asString;
    add: '] at index: ';
    add: index asString;
    add: ' has key ';
    add: k printString printString;
    add: ' out of order [';
    add: k asOop asString;
    add: '] that sorts greater than previous key';
    add: previousKey printString printString;
    add: ' [';
    add: previousKey asOop asString;
    add: ']';
    add: Character lf .
  self checkDebug

]

{ #category : 'Audit' }
BtreePlusNodeAuditor >> checkDebug [ 
  self class checkDebug: auditResultString

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> dependencyListHasIncorrectIvOffset: pathTerm object: obj indexObj: indexObj depList: depList ivOffset: ivOffset expectedIvOffset: expectedIvOffset [
  pathTerm auditInfo: {obj.
      indexObj.
      depList} using: self.
  auditResultString
    add: 'DependencyList has incorrect iv offset ';
    add: ivOffset asString;
    add: ' instead of ';
    add: expectedIvOffset asString;
    add: Character lf .
  self checkDebug

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> dependencyListHasIncorrectRefCount: pathTerm object: obj indexObj: indexObj depList: depList referenceCount: referenceCount numOccurrences: num [
  pathTerm auditInfo: {obj.
      indexObj.
      depList} using: self.
  auditResultString
    add: ' DependencyList has incorrect ref count ';
    add: referenceCount asString;
    add: ' for occurrences ';
    add: num asString;
    add: Character lf .
  self checkDebug

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> dependencyListHasNoEntryForPathTerm: pathTerm object: obj indexObj: indexObj depList: depList [
  pathTerm auditInfo: {obj.
      indexObj.
      depList} using: self.
  auditResultString
    add: 'DependencyList has no entry for path term';
    add: Character lf .
  self checkDebug

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> dependencyListUnexpectedLastElementLocation: pathTerm object: obj indexObj: indexObj depList: depList ivOffset: ivOffset [
  pathTerm auditInfo: {obj.
      indexObj.
      depList} using: self.
  auditResultString
    add: ' DependencyList on last element in unexepected location ';
    add: ivOffset asString;
    add: Character lf .
  self checkDebug

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> pathTermIncorrectNilOnPathCount: pathTerm root: root got: actual  expected: expected [
  auditResultString
    add: Character lf;
    add: ' -- Incorrect nil on path count for pathTerm [';
    add: pathTerm asOop asString;
    add: '] expected ';
    add: expected asString;
    add: ' got ';
    add: actual asString;
    add: ' for root object [';
    add: root asOop asString;
    add: '].';
    add: Character lf .
  self checkDebug

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> pathTermIncorrectNumberOfBtreeEntries: pathTerm index: i offset: offset [
  auditResultString
    add: Character lf;
    add: ' -- The number of entries in Btree [';
    add: (pathTerm at: i) btreeRoot asOop asString;
    add: '] for pathTerm [';
    add: pathTerm asOop asString;
    add: '] offset ';
    add: offset asString;
    add: ' does not match the number of entries in the base collection (extra elements in either the base collection or btree).';
    add: Character lf .
  self checkDebug

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> pathTermInvalidIvOffset: pathTerm ivOffset: ivOffset object: obj [
  auditResultString
    add: Character lf;
    add: ' -- Invalid ivOffset for pathTerm [';
    add: pathTerm asOop asString;
    add: ' an instance variable name [';
    add: pathTerm name asString;
    add: '] at ivOffset ';
    add: ivOffset asString;
    add: ' in the object [';
    add: obj asOop asString;
    add: '] does not exist.';
    add: Character lf .
  self checkDebug

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> pathTermObjectHasNoDependencyBitSet: pathTerm object: obj indexObj: indexObj depList: depList [
  pathTerm auditInfo: {obj.
      indexObj.
      depList} using: self.
  auditResultString
    add: ' Object has DependencyList but no dependency bit is set';
    add: Character lf .
  self checkDebug

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> pathTermObjectHasNoDependencyList: pathTerm object: obj indexObj: indexObj depList: depList [
  pathTerm auditInfo: {obj.
      indexObj.
      depList} using: self.
  auditResultString
    add: ' Object has no dependency list';
    add: Character lf .
  self checkDebug

]

{ #category : 'pathterm audit failures' }
BtreePlusNodeAuditor >> setValuedPathTermExtraNilOnPathCount: pathTerm root: root excessCount: excessNilOnPathCount [   auditResultString
    add: Character lf;
    add: ' -- Nil on path count too high for pathTerm [';
    add: pathTerm asOop asString;
    add: '] excess ';
    add: excessNilOnPathCount asString;
    add: ' for root object [';
    add: root asOop asString;
    add: '].';
    add: Character lf .
  self checkDebug

]
