Extension { #name : 'BtreePlusUnicodeComparisonQuerySpec' }

{ #category : 'Accessing' }
BtreePlusUnicodeComparisonQuerySpec >> collator [
  ^ collator

]

{ #category : 'Accessing' }
BtreePlusUnicodeComparisonQuerySpec >> collator: anIcuCollator [
  collator :=  anIcuCollator

]

{ #category : 'Comparing' }
BtreePlusUnicodeComparisonQuerySpec >> compare: entry using: sel [
  ^ sel numArgs == 1
    ifTrue: [ entry perform: sel with: key ]
    ifFalse: [ entry perform: sel with: key with: self collator ]

]

{ #category : 'Comparing' }
BtreePlusUnicodeComparisonQuerySpec >> compareKey: entry [
  ^ selector numArgs == 1
    ifTrue: [ entry perform: selector with: key ]
    ifFalse: [ entry perform: selector with: key with: self collator ]

]

{ #category : 'Updating' }
BtreePlusUnicodeComparisonQuerySpec >> key: aKey selector: aSelector [
  key := aKey.
  opCode := self operationSelectors indexOf: aSelector.
  selector := self unicodePerformSelector: opCode

]

{ #category : 'Accessing' }
BtreePlusUnicodeComparisonQuerySpec >> performSelectors [
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'_idxForCompareEqualTo:collator:' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'_idxForCompareNotEqualTo:collator:' #'~~')

]
