Extension { #name : 'CCallin' }

{ #category : 'Instance creation' }
CCallin class >> name: aName result: resType args: argumentTypes [
  ^ self name: aName result: resType args: argumentTypes envId: 0"default smalltalk"

]

{ #category : 'Instance creation' }
CCallin class >> name: aName result: resType args: argumentTypes  envId: envId [

"aName, resType are per comments in  CCallout(C)>>library:name:result:args: .

 argumentTypes must specify all of the arguments to be passed ,
 per comments in  library:name:result:args:  argumentTypes may not contain
 a CCallin .

 resType may not be a CCallin

 C varargs are not allowed
"
  | res |
  (res := self _basicNew)
      _name: aName result: resType
			args: argumentTypes varArgsAfter: -1 ;
     envId: envId  .
  res immediateInvariant . "uses must make a copy"
  ^ res

]

{ #category : 'Private' }
CCallin >> _bindTo: aBlock [

"Install aBlock as the code to be executed when
 the receiver is called from C ."

<primitive: 324>
aBlock _validateClass: ExecBlock .
self _primitiveFailed: #_bindTo:
      args: { aBlock }

]

{ #category : 'Private' }
CCallin >> _copyForCFunction [

 | res |
  "must use _basicNew to create cData slot"
 (res := self class _basicNew)
   _fname: fName argTypes: argTypes resultType: resultType
        cTypes: cTypes argCounts: argCounts
        argTypesDict: argTypesDict envId: envId  .
 ^ res

]

{ #category : 'Private' }
CCallin >> _fname: afName argTypes: aargTypes resultType: aresultType
  cTypes: acTypes argCounts: aargCounts
  argTypesDict: aargTypesDict envId: aenvId [

  fName := afName  .
  argTypes := aargTypes  .
  resultType := aresultType .
  cTypes := acTypes  .
  argCounts := aargCounts .
  argTypesDict := aargTypesDict  .
  envId := aenvId  .

]

{ #category : 'Accessing' }
CCallin >> callinName [
  ^ fName

]

{ #category : 'Binding' }
CCallin >> copyBindTo: aBlock [

"Return a copy of the receiver which is bound to
 the specified block.  The result would typically be
 used as second arg to CByteArray>>ccallinAt:put:  when
 building an Array of function pointers."

^ self _copyForCFunction _bindTo: aBlock

]

{ #category : 'Initialization' }
CCallin >> envId: anEnvId [

  envId := anEnvId

]
