Extension { #name : 'CCallout' }

{ #category : 'Obsolete' }
CCallout class >> errno [

"Obsolete; not thread-safe. Use CCallout >> callWith:errno:
 Returns the SmallInteger value of the current GsProcess's ffiErrno."

 ^ Error signal:'CCallout class>>errno  Not supported  , see CCallout>>callWith:errno:' .

]

{ #category : 'Obsolete' }
CCallout class >> errno: aSmallInteger [
 "Obsolete; not thread-safe. Use CCallout >> callWith:errno:
  Stores aSmallInteger into the current GsProcess's ffiErrno ,
  and returns the previous value of ffiErrno as a SmallInteger."

 ^ Error signal:'CCallout class>>errno:  Not supported  , see CCallout>>callWith:errno:' .

]

{ #category : 'Instance creation' }
CCallout class >> library: aCLibrary name: aName result: resType args: argumentTypes [

" aCLibrary may be a CLibrary,  or nil if current process should
  be searched with dlsym(),
  or an Array of CLibraries to be searched.
  See CFunction(C)>>comment for more details.

  aName must be a String .  It will be used as arg to dlsym() at the first
  time the function is called.

  resType is one of
    #int64    -->  C function returns an int64, or any unsigned C integer
                smaller than 64bits ; call will return an Integer
    #uint64   -->  C function returns a uint64 ; call will return an Integer
    #int32    -->  C function returns a signed C integer 32bits or smaller;
		   call will return a SmallInteger;
		   #int64 can be used instead of #int32 on Sparc only .
    #uint32   -->  C function returns a C uint ; call returns a SmallInteger.
    #int16    -->  C function returns a C short ; call returns a SmallInteger
    #uint16   -->  C function returns a C ushort ; call returns a SmallInteger
    #int8     -->  C function returns a C char ; call returns a SmallInteger
    #uint8    -->  C function returns a C uchar ; call returns a SmallInteger

    #bool     --  C function returns zero or non-zero C integer of any size
                     call returns TRUE or FALSE
    #double    -->  C function returns an C double,
                call will return a SmallDouble or Float .
    #float     -->  C function returns an C float,
                call will return a SmallDouble or Float .
    #ptr      -->  call will return nil or a CPointer
    #'char*'  -->  call will return nil or a String
    #void     -->  call always returns nil
    #struct   -->  receiver must be a CCalloutStructs, see
                 CCalloutStructs class >> library:name:result:args:varArgsAfter:structSizes:

  argumentTypes is an Array of zero or more elements. Each element is one of
    #int64     --> arg must be an Integer representable as a C int64
    #uint64    --> arg must be an Integer representable as a C uint64
    #int32     --> arg must be an Integer representable as a C 32bit int
    #uint32    --> arg must be an Integer representable as a C 32bit uint
    #int16     --> arg must be an Integer representable as a C 16bit short
    #uint16    --> arg must be an Integer representable as a C 16bit ushort
    #int8     --> arg must be an Integer representable as a C 8 bit signed char
    #uint8    --> arg must be an Integer representable as a C 8 bit uchar

    #bool     --> arg must ba a Boolean

    #double    --> arg must be a SmallDouble or Float ,
    #float    --> arg must be a SmallDouble or Float
    #ptr       --> arg must be nil, a CByteArray or a CPointer  ,
                if nil , C  NULL is passed .
		if CByteArray, address of body is passed .
                if CPointer, the encapsulated  pointer is passed .
    #'&ptr'    -->  arg must be a CPointer whose value
                  will be passed and updated on return.
    #'char*'   --> arg must be a non-nil String in which case
               body is copied to C memory before call and copied
                from C memory (and possible grown/shrunk) after call.
                C memory will not be valid after the call finishes.
                The C memory copy of the String has a zero byte appended.
                Unicode7 is allowed. Utf8, Uncode16, Unicode32 are not allowed.
    #'const char*'  --> arg must be nil( to pass NULL)
                or a String or Utf8 (body is copied to C memory before call) 
                C memory will not be valid after the call finishes.
                The C memory copy of the String has a zero byte appended.
                Unicode7 is allowed. Uncode16, Unicode32 are not allowed.
    #'const UChar*'  --> arg must be nil (to pass NULL)
 	 or a Unicode7, Uncode16, or Unicode32, or Utf8.
         The body of the string is copied to C memory in UTF16 form before
         the call.
         The C memory copy has a codepoint zero appended.
         C memory will not be valid after the call finishes.

    #'UChar*' --> arg must be a Unicode7, Uncode16, or Unicode32.
         The body of the string is copied to C memory in UTF16 form before
         the call, and copied back from C memory after the call.
         The C memory copy has a codepoint zero appended.
         The copy back may grow or shrink the arg, and may become the arg
         to a Uncode16 or a Unicode32.

    #struct   -->  receiver must be a CCalloutStructs, see
                 CCalloutStructs class >> library:name:result:args:varArgsAfter:structSizes:

    See comments in CCallout>>callWith: for details on calling with varArgs.

    Note C strings which should persist in C memory after a function call
    should be passed using CByteArray created from an instance of String.

    When native code is disabled in the gem config file, use of double or
    float args imply a maximum of 4 arguments , excluding var args ."

  | res |
  (res := self _basicNew) _setLibrary: aCLibrary ;
     _name: aName result: resType args: argumentTypes varArgsAfter: -1 .
  ^ res
]

{ #category : 'Instance creation' }
CCallout class >> library: aCLibrary name: aName result: resType args: argumentTypes
varArgsAfter: varArgsAfter [

"aCLibrary, aName, resType are per comments in  library:name:result:args: .

 argumentTypes must specify all of the arguments to be passed ,
 per comments in  library:name:result:args:  .

 If C varargs allowed, varArgsAfter must be >=0   and
    <  argumentTypes size   , and must also be <=4  ,
 else varArgsAfter==-1 to denote no varargs .

 For example, if varArgsAfter==3 and  (argumentTypes size == 5)
 and none of argumentTypes or resType specify #double,
 a C function call of the form
    f(a,b,c,d,e);
 will be made using a prototype of the form
    intptr_t f(intptr_t a, intptr_t b, intptr_t c, ...);
"
  | res |
  (res := self _basicNew) _setLibrary: aCLibrary ;
      _name: aName result: resType
			args: argumentTypes varArgsAfter: varArgsAfter .
  ^ res
]

{ #category : 'Private' }
CCallout >> _bindFunction: aCpointer [
  "Install  aCpointer memoryAddress  as the address of the C function"
  <primitive: 1036>
  aCpointer _validateClass: CPointer .
  self _primitiveFailed: #_bindFunction args: { aCpointer }

]

{ #category : 'Private' }
CCallout >> _library [
  ^ library
]

{ #category : 'Private' }
CCallout >> _setLibrary: aCLibrary [

 aCLibrary ifNotNil:[ aCLibrary _validateClass: CLibrary ] .
 library := aCLibrary .

]

{ #category : 'Private' }
CCallout >> bind [
  "Attempt to resolve the C function described by the receiver,
   using dlopen() if needed, and dlsym() ."

  <primitive: 529>
  lastError ifNotNil:[   "lastError was set by the primitive"
     ^ ArgumentError signal: lastError .
  ].
  self _primitiveFailed: #bind

]

{ #category : 'Calling' }
CCallout >> callWith: argsArray [

"invoke the function described by the receiver.
 First send of this method during a lifetime of the receiver in memory
 triggers dlopen() (if needed) , dlsym() , and generation of native code for
 callout stub(if native code enabled by configuration file) .
 If function expects zero args,  argsArray must be an empty array or nil.
 If function supports varArgs, then the variable args come after the
 fixed arguments in argsArray, and each variable arg is represented
 as 2 elements of argsArray,
    a typeSymbol, and an argValue .
 The typeSymbol must occur as a key in the class variable ArgTypesDict.
 If native code configured, uses the callout stub's native
 code to marshal arguments into C register/stack, else uses a C switch
 statement which only supports a limited range of function signatures
 and does not support C float arguments .

 See  CCallout class >>library:name:result:args:  for further details.

 Cannot be used if result type is #struct, nor if any argument is of type #struct .
 "

 <primitive: 710>
 | nPassed nRequired |
 lastError ifNotNil:[   "lastError was set by the primitive"
    ^ ArgumentError signal: lastError .
 ].
 argsArray class == Array ifFalse:[
   ArgumentTypeError new name:'argsArray' expectedClass: Array actualArg: argsArray ;
        signal .
 ].
 (nPassed := argsArray size) == (nRequired := argTypes size) ifFalse:[
   ArgumentError new signal:
     nPassed asString , ' args given , ' , nRequired asString, ' args required for:  ' ,
       self signatureString .
 ].
 ^ self _primitiveFailed: #callWith: args: { argsArray }
]

{ #category : 'Calling' }
CCallout >> callWith: argsArray errno: errnoArg [

"Invoke the function described by the receiver.
 First send of this method during a lifetime of the receiver in memory
 triggers dlopen() (if needed) , dlsym() , and generation of native code for
 callout stub(if native code enabled by configuration file) .
 If function expects zero args,  argsArray must be an empty array or nil.
 If function supports varArgs, then the variable args come after the
 fixed arguments in argsArray, and each variable arg is represented
 as 2 elements of argsArray,
    a typeSymbol, and an argValue .
 The typeSymbol must occur as a key in the class variable ArgTypesDict.
 If native code configured, uses the callout stub's native
 code to marshal arguments into C register/stack, else uses a C switch
 statement which only supports a limited range of function signatures
 and does not support C float arguments .

 The errnoArg, if not nil , must be an Array . If the array is of size >= 1
 and the first element is a SmallInteger whose value fits in a 32bit signed
 integer, that value is stored into the ffiErrno of the current process
 before calling the function specified by argsArray. The first element
 may be nil, in which case  ffiErrno of the current GsProcess is not changed
 before calling the function.

 Before calling the function, this primitive executes   
   errno = currentGsProcess.ffiErrno .

 If errnoArg is an Array , then after the called function returns,
 the value of errno is stored as the first element of errnoArg ,
 in addition to being stored into currentGsProcess.ffiErrno .

 See  CCallout class >>library:name:result:args:  for further details.
 "
 <primitive: 171>
 | nPassed nRequired |
 lastError ifNotNil:[   "lastError was set by the primitive without self.markDirty"
    ^ ArgumentError signal: lastError .
 ].
 argsArray class == Array ifFalse:[
   ArgumentTypeError new name:'argsArray' expectedClass: Array actualArg: argsArray ;
        signal .
 ].
 (nPassed := argsArray size) == (nRequired := argTypes size) ifFalse:[
   ArgumentError new signal:
     nPassed asString , ' args given , ' , nRequired asString, ' args required for:  ' ,
       self signatureString .
 ].
 errnoArg ifNotNil:[ 
   errnoArg class == Array ifFalse:[
     ArgumentTypeError new name:'errnoArg' expectedClass: Array actualArg: errnoArg ; signal .
   ].
   (errnoArg atOrNil: 1) ifNotNil:[:v | | lim |
      v _validateClass: SmallInteger .
      lim := SmallInteger maximum32bitInteger . 
      (v > lim or:[ v < (lim negated - 1)]) ifTrue:[
        Error signal:'(errnoArg at: 1)=', v asString,'  exceeds range of 32bit signed integer'.
      ].
   ].
 ].
 ^ self _primitiveFailed: #callWith: args: { argsArray }
]

{ #category : 'Accessing' }
CCallout >> version [
  ^ self dynamicInstVarAt: #version
]

{ #category : 'Accessing' }
CCallout >> version: aString [
  "aString will be used as third arg to dlvsym() "
  ^ self dynamicInstVarAt: #version put: aString
]
