Extension { #name : 'CCalloutStructs' }

{ #category : 'Instance creation' }
CCalloutStructs class >> library: aCLibrary name: aName result: resType args: argumentTypes varArgsAfter: varArgsAfter structSizes: structSizes [
" aCLibrary may be a CLibrary,  or nil if current process should
  be searched with dlsym(),
  or an Array of CLibraries to be searched.
  See CFunction(C)>>comment for more details.

  aName must be a String .  It will be used as arg to dlsym() at the first
  time the function is called.

  resType may be
      #struct  -->  returns a CByteArray, must call via CCalloutStructs>>callWith:structResult:errno:
        size of the result is specified by first element of the  Array referenced
        by structSizes instVar .
    or any of the resType listed in CCallout class >> library:name:result:args: 

  argumentTypes is an Array of zero or more elements. Each element is one of
    #struct --> arg must be a kind of CByteArray , this is a struct passed by value.
       size of the CByteArray must match the corresponding element of the
       Array referenced by structSizes instVar .
       Receiver must be a CCalloutStructs.
    or any of the argumentTypes listed in CCallout class >> library:name:result:args:


 argumentTypes must specify all of the arguments to be passed ,
 per comments in  library:name:result:args:  .


 structSizes should be an Array of size  (argumentTypes size + 1) .
 Elements are nil or a SmallInteger, size in bytes of a CByteArray representing a struct.
 First element is size of result if resType==#struct , subsequent elements are
 nil or size of respective argument of type #struct .

 If C varargs allowed, varArgsAfter must be >=0   and
    <  argumentTypes size   , and must also be <=4  ,
 else varArgsAfter==-1 to denote no varargs . "

  | res |
  (res := self _basicNew) _setLibrary: aCLibrary ;
      _name: aName result: resType
			args: argumentTypes varArgsAfter: varArgsAfter structSizes: structSizes .
  ^ res
]

{ #category : 'Private' }
CCalloutStructs >> _name: aName result: resType args: argumentTypes varArgsAfter: varArgsAfter structSizes: sSizes [
  super _name: aName result: resType args: argumentTypes varArgsAfter: varArgsAfter .

  sSizes class == Array ifFalse:[ ArgumentError new name: 'structSizes'; signal: ' is not an Array'].
  resType == #struct ifTrue:[
    self _checkStructSize: (sSizes at: 1) descr: 'result'.
  ].
  1 to: argumentTypes size do:[:j | | v |
    (argumentTypes at:j) == #struct ifTrue:[
      self _checkStructSize:(v := sSizes at: j + 1) descr: 'arg',j asString .
    ] ifFalse:[
      (v := sSizes at: j + 1) ifNotNil:[ 
         Error signal:'structSizes element ', (j+1) asString ,' is not nil'.
      ].
    ].
  ].
  structSizes := sSizes .
]

{ #category : 'Private' }
CCalloutStructs >> _checkStructSize: aVal descr: aString [
  aVal _isSmallInteger ifFalse:[ Error signal:'struct size must be a SmallInteger'].
  (aVal < 8 or:[ aVal > 8192 or:[ (aVal \\ 8) ~~ 0]]) ifTrue:[
     Error signal:'invalid size of struct ', aString asString,' ', aVal asString,
        ', expected a multiple of 8 beteen 8 and 8192'. 
  ]
]

{ #category : 'Calling' }
CCalloutStructs >> callWith: argsArray [
 ^ self callWith: argsArray structResult: nil errno: nil
]

{ #category : 'Calling' }
CCalloutStructs >> callWith: argsArray errno: errnoArg [
 ^ self callWith: argsArray structResult: nil errno: errnoArg
]

{ #category : 'Calling' }
CCalloutStructs >> callWith: argsArray structResult: aCByteArray errno: errnoArg [

"Invoke the function described by the receiver.
 First send of this method during a lifetime of the receiver in memory
 triggers dlopen() (if needed) , dlsym() , and generation of native code for
 callout stub(if native code enabled by configuration file) .
 If function expects zero args,  argsArray must be an empty array or nil.
 If function supports varArgs, then the variable args come after the
 fixed arguments in argsArray, and each variable arg is represented
 as 2 elements of argsArray,
    a typeSymbol, and an argValue .
 The typeSymbol must occur as a key in the class variable ArgTypesDict.
 Uses a C switch statement which only supports a limited range of function signatures
 and does not support C float arguments .

 Supports arguments of type #struct , with sizes of those arguments specified
 in the Array referenced by structSizes instVar .
 Doubles are not supported in small (< 16 bytes) structs nor as scalar args.

 Returns the result of the called function .

 If resultType == #struct , then aCByteArray must be a kind of CByteArray
 with size equal to the size specified by first element of the Array referenced by 
 structSizes instVar, and the method will return aCByteArray ,
 otherwise aCByteArray must be nil.

 The errnoArg, if not nil , must be an Array . If the array is of size >= 1
 and the first element is a SmallInteger whose value fits in a 32bit signed
 integer, that value is stored into the ffiErrno of the current process
 before calling the function specified by argsArray. The first element
 may be nil, in which case  ffiErrno of the current GsProcess is not changed
 before calling the function.

 Before calling the function, this primitive executes   errno = currentGsProcess.ffiErrno .

 If errnoArg is an Array , then after the called function returns,
 the value of errno is stored as the first element of errnoArg ,
 in addition to being stored into currentGsProcess.ffiErrno .

 See  CCallout class >>library:name:result:args:  and
      CCalloutStructs class >> library:name:result:args:varArgsAfter:structSizes:
 for further details.
 "
 <primitive: 77>
 | nPassed nRequired |
 lastError ifNotNil:[   "lastError was set by the primitive without self.markDirty"
    ^ ArgumentError signal: lastError .
 ].
 argsArray class == Array ifFalse:[
   ArgumentTypeError new name:'argsArray' expectedClass: Array actualArg: argsArray ;
        signal .
 ].
 (nPassed := argsArray size) == (nRequired := argTypes size) ifFalse:[
   ArgumentError new signal:
     nPassed asString , ' args given , ' , nRequired asString, ' args required for:  ' ,
       self signatureString .
 ].
 errnoArg ifNotNil:[ 
   errnoArg class == Array ifFalse:[
     ArgumentTypeError new name:'errnoArg' expectedClass: Array actualArg: errnoArg ; signal .
   ].
   (errnoArg atOrNil: 1) ifNotNil:[:v | | lim |
      v _validateClass: SmallInteger .
      lim := SmallInteger maximum32bitInteger . 
      (v > lim or:[ v < (lim negated - 1)]) ifTrue:[
        Error signal:'(errnoArg at: 1)=', v asString,'  exceeds range of 32bit signed integer'.
      ].
   ].
 ].
 aCByteArray _validateClass: CByteArray . 
 ^ self _primitiveFailed: #callWith: args: { argsArray }
]

{ #category : 'Accessing' }
CCalloutStructs >> version [
  ^ version
]

{ #category : 'Accessing' }
CCalloutStructs >> version: aString [
  "aString will be used as third arg to dlvsym() "
  version := aString .
  ^ aString
]
