Extension { #name : 'CPointer' }

{ #category : 'Private' }
CPointer class >> basicNew [
 "disallowed"
  self shouldNotImplement: #basicNew

]

{ #category : 'Private' }
CPointer class >> new [
 "disallowed"
  self shouldNotImplement: #new

]

{ #category : 'Instance creation' }
CPointer class >> newFrom: aCByteArray [

"Return a new instance of CPointer which is a reference to body
 of a CByteArray.
 The result can be used as an argument a CFunction which has
 type #'ptr' or #'&ptr' . "

^ self _allocate _initFrom: aCByteArray offset: 0

]

{ #category : 'Private' }
CPointer class >> _allocate [
  "Create a new instance with value NULL.
   The result can be used as an argument a CFunction which has
   type #'ptr' or #'&ptr' .

   Non-NULL instances are also returned from CFunction calls when result
   type is  #ptr ; pass such instances to CByteArray classmethods to
   get an instance of CByteArray with which to access the data.
 "

<primitive: 674>  "instance is registered with VM for CData finalization"
^ self _primitiveFailed: #allocate

]

{ #category : 'Instance creation' }
CPointer class >> newNull [
  ^ self _allocate _initFrom: nil offset: 0 .
]

{ #category : 'Instance creation' }
CPointer class >> forAddress: anInteger [
  "anInteger must be representable as an unsigned 64bit integer."
  
   ^ self _allocate _initFrom: anInteger offset: 0 
]

{ #category : 'Private' }
CPointer >> _initFrom: anObject  offset: zeroBasedOffset [
 "anObject==nil means init to represent a NULL pointer, oherwise
  anObject must be either a CByteArray or an unsigned 64bit integer.
  returns self . "
 <primitive: 718>
 anObject _validateKindOfClasses: { CByteArray . Integer }.
 (anObject isKindOf: CByteArray) ifTrue:[
   anObject memoryAddress == 0 ifTrue:[
     "CByteArray might be a committed instance faulted."
     ArgumentError signal:'CByteArray has NULL C memory address'.
   ].
 ].
 zeroBasedOffset _validateClass: SmallInteger .
 ArgumentError signal:'zeroBasedOffset out of bounds '.
 self _primitiveFailed: #_initFrom:offset:
      args: { anObject . zeroBasedOffset }

]

{ #category : 'Formatting' }
CPointer >> _inspect [
  | res |
  (res := String new)
    add: ' address=0x' ; add: self memoryAddress asHexString .
  ^ res

]

{ #category : 'Formatting' }
CPointer >> asString [
  | res |
  (res := super asString ) add: self _inspect .
  ^ res

]

{ #category : 'Accessing' }
CPointer >> _access: opcode [
  "Opcode
    0 returns the starting address of the C memory, as an unsigned 64bit Integer.
    1 assume NUL terminated char* data and return a String .
    2 assume NUL terminated char* data and return a UTF8 .
    3 decode NUL terminated UTF8 data returning a String or DoubleByteString .
    4 decode NUL terminated UTF8 data returning a Unicode7, or Unicode16
  " 
<primitive: 846>
opcode _validateClass: SmallInteger .
^ self _primitiveFailed: #_access: args: { opcode }

]

{ #category : 'Accessing' }
CPointer >> memoryAddress [
  "Returns the starting address of the C memory, as a unsigned 64bit Integer."

  ^ self _access: 0 
]

{ #category : 'Accessing' }
CPointer >> stringFromCharStar  [
  "Return a String from the char* data starting at self memoryAddress"
  ^ self _access: 1 
]

{ #category : 'Accessing' }
CPointer >> utf8FromCharStar  [
  "Return a Utf8 from the char* data starting at self memoryAddress"
  ^ self _access: 2 
]

{ #category : 'Accessing' }
CPointer >> decodeFromUTF8ToString  [
  "Decode the NUL terminated UTF8 data starting at self memoryAddress 
   and return a String, DoubleByteString or QuadByteString"
  ^ self _access: 3 
]

{ #category : 'Accessing' }
CPointer >> decodeFromUTF8ToUnicode  [
  "Decode the NUL terminated UTF8 data starting at self memoryAddress 
   and return a Unicode7, Unicode16 or Unicode32"
  ^ self _access: 4 
]

{ #category : 'Testing' }
CPointer >> isNull [
"Answer true if the receiver is a NULL pointer, false otherwise."

^ self memoryAddress == 0
]

{ #category : 'Testing' }
CPointer >> notNull [
"Answer true if the receiver is not a NULL pointer, false otherwise."

^ self memoryAddress ~~ 0
]
