"
This class is internal to the FFI implementation and 
implements a stream that can track file names and line numbers from 
debug info emitted by /usr/bin/cpp, and parsed by a CPreprocessor.
Instance variables
  file  a String,  path to a file.
  line  a SmallInteger , a line number .
  cppArchMType  nil or a SmallInteger .
  debug  used to enable debugging info in CPreprocessorToken .
"
Class {
	#name : 'CPreprocessorStream',
	#superclass : 'ReadStreamPortable',
	#instVars : [
		'file',
		'line',
		'cppArchMType',
    'debug'
	],
	#category : 'FFI'
}

{ #category : 'private' }
CPreprocessorStream class >> on: anObj [
  anObj size == 0 ifTrue:[ 
    anObj = '' ifFalse:[
      ^ ArgumentError signal:'expect non-zero size collection argument'
    ].
  ].
  ^ super on: anObj
]

{ #category : 'Accessing' }
CPreprocessorStream >> cppArchMType [
  ^ cppArchMType

]

{ #category : 'Accessing' }
CPreprocessorStream >> cppArchMType: aSmallInt [
  cppArchMType := aSmallInt

]

{ #category : 'Accessing' }
CPreprocessorStream >> file [
  "Returns a String, a file name"
  ^ file

]

{ #category : 'Accessing' }
CPreprocessorStream >> file: aFileName [
  file := aFileName

]

{ #category : 'Accessing' }
CPreprocessorStream >> line [
  ^ line
]

{ #category : 'Accessing' }
CPreprocessorStream >> line: aLineNumber [
  line := aLineNumber
]

{ #category : 'Accessing' }
CPreprocessorStream >> debug: aBoolean [
  "aBoolean == true enables some debug details in CPreprocessorToken ."
  ^ debug := aBoolean .
]
{ #category : 'Accessing' }
CPreprocessorStream >> debug [
  ^ debug 
]

