"
CanonicalSymbolDict is the class of AllSymbols. Instances may
 only be modified by SystemUser, or the SymbolCreation session.

Constraints:
	numElements: SmallInteger
	tableSize: SmallInteger
"
Class {
	#name : 'CanonSymbolDict',
	#superclass : 'CanonStringDict',
	#gs_reservedoop : '119553',
	#category : nil
}

{ #category : 'Private' }
CanonSymbolDict >> _initializeWithoutClear: newSize [

"Private. Initializes the instance variables of the receiver to be an empty
 KeyValueDictionary of the specified size. Does not clear the contents
 of the receiver - assumes they are all nil."

self validateSystemUser .
super _initializeWithoutClear: newSize .
^self

]

{ #category : 'Private' }
CanonSymbolDict >> _resetParentRef [

"Private. After a become:, the parent refs of the collisionBuckets must
 be reset to point to the correct parent."

self validateSystemUser .
^ super _resetParentRef

]

{ #category : 'Adding' }
CanonSymbolDict >> add: aString [

"Disallowed, only the Virtual machine's creation of a Symbol
 should add elements to AllSymbols."

^ self shouldNotImplement: #add:


]

{ #category : 'Adding' }
CanonSymbolDict >> addAll: aCollection [

"Disallowed, only the Virtual machine's creation of a Symbol
 should add elements to AllSymbols."

^ self shouldNotImplement: #addAll:

]

{ #category : 'Adding' }
CanonSymbolDict >> addKey: aSymbol [

"Only used during repository conversion."

self validateSystemUser .
"We expect that AllSymbols is not yet an instance of this class."
(Globals at:#AllSymbols) class == CanonSymbolDict ifTrue:[
  ^ self error:'Illegal use for other than repository conversion' .
].
aSymbol class == Symbol ifFalse:[
  aSymbol class == DoubleByteSymbol ifFalse:[
    ^ self error:'bad argument class ' , aSymbol class name
  ].
].
^ super add: aSymbol .

]

{ #category : 'Updating' }
CanonSymbolDict >> become: aCanonSymbolDict [

^ self shouldNotImplement: #become:

]

{ #category : 'Initializing' }
CanonSymbolDict >> initialize: itsSize [

"Initializes the instance variables of the receiver to be an empty
 dictionary of the specified size."

self validateSystemUser .
super initialize: itsSize

]

{ #category : 'Private' }
CanonSymbolDict >> objectSecurityPolicy: anObjectSecurityPolicy [

"Assigns the receiver and all its components to the given security policy.
 Returns the receiver."

self validateSystemUser .
^ super objectSecurityPolicy: anObjectSecurityPolicy

]

{ #category : 'Removing' }
CanonSymbolDict >> remove: aString [

^ self shouldNotImplement: #remove:

]

{ #category : 'Removing' }
CanonSymbolDict >> remove: aString ifAbsent: aBlock [

^ self shouldNotImplement: #remove:ifAbsent:

]

{ #category : 'Removing' }
CanonSymbolDict >> removeKey: aKey ifAbsent: aBlock [

"Removing Symbols from AllSymbols is not supported.
 If you want to remove Symbols from AllSymbols anyway:
   1. You must logged in as SystemUser, and edit this method to remove
      the line with
         shouldNotImplement
      and uncomment the line with
         removeKey:
      And commit these changes.
   2. Stop the Symbol Creation Session, and all other user sessions
        System stopSymbolCreationSession.
        System stopUserSessions.
   3. The Symbols to be removed from AllSymbols must be referenced ONLY
      from AllSymbols, as confirmed by SystemRepository listReferences:.
      OTHERWISE message sends may fail to lookup the proper method
      and you may get other INCORRECT EXECUTION.
   4. execute removals from AllSymbols using this method, and commit.
   5. Start Symbol Creation session using
        System startSymbolCreationSession.

 Use this process at your own risk.
"

self validateSystemUser .
self shouldNotImplement: #removeKey:ifAbsent: .
"^ super removeKey: aKey ifAbsent: aBlock"

]

{ #category : 'Private' }
CanonSymbolDict >> validateSystemUser [

"validate that the current session is SystemUser."

System myUserProfile userId = 'SystemUser' ifFalse:[
  self error:'instance only modifiable by SystemUser'.
  self _uncontinuableError .
  ^ nil
  ].
^ self

]

{ #category : 'Copying' }
CanonSymbolDict >> postCopy [
  1 to: self _basicSize do:[:n | | bkt newBkt |
    bkt := self _basicAt: n .
    (newBkt := bkt copy) keyValueDictionary: self .
    self _basicAt: n put: newBkt
  ].
]

{ #category : 'Audit' }
CanonSymbolDict >> _audit [
  "Returns a SmallInteger, the number of errors found."
  | errCount |
  GsFile gciLogServer: '---- CanonSymbolDict oop ', self asOop asString, ' size ', self size asString,
     ' tableSize ', self tableSize asString .
  errCount := 0 .
  1 to: self _basicSize do:[:n | | bkt |
    bkt := self _at: n .
    bkt ifNotNil:[
      errCount := errCount + ( bkt _audit: self offset: n) .
    ].
  ].   
  GsFile gciLogServer: '---- CanonSymbolDict oop ', self asOop asString,' error count ', errCount asString .
  ^ errCount .
]

