"
This protocol describes the behavior that is common to date
time objects. Date time objects represent individual points
in Coordinated Universal Time (UTC) as represented in an
implementation defined local time, with a default resolution
of seconds.

The exact properties of local times are unspecified. Local
times may differ in their offset from UTC. A given local time
may have different offsets from UTC at different points in time.

All dates and times in the UTC local time are in the Gregorian
calendar. Date times prior to the adoption of the Gregorian
calendar are given in the retrospective astronomical Gregorian
calendar. The year 1 B.C. is astronomical Gregorian year 0.
The year 2 B.C. is astronomical Gregorian year-1. The year 1 A.D.
is astronomical Gregorian year 1. The offset of the UTC local
time is zero.
"
Class {
	#name : 'DateAndTimeANSI',
	#superclass : 'Magnitude',
	#instVars : [
		'seconds',
		'offset'
	],
	#gs_options : [
		'selfCanBeSpecial'
	],
	#category : nil
}
