Extension { #name : 'EnumeratedPathEvaluator' }

{ #category : 'Accessing' }
EnumeratedPathEvaluator >> enumeratedObjectsFor: theObj pathTerm: enumeratedPathName at: nscOffset [
  | nextObj ivOffset enumeratedObjects |
  nextObj := theObj.
  nil == nextObj
    ifTrue: [ ^ #() ].
  enumeratedObjects := {}.
  (enumeratedPathName subStringsDelimitedBy: $|)
    do: [ :pathName |
      ivOffset := nextObj class _idxIvOffsetOf: pathName asSymbol.
      ivOffset == nil
        ifTrue: [ enumeratedObjects add: nil ]
        ifFalse: [ enumeratedObjects add: (nextObj instVarAt: ivOffset) ] ].
  ^ enumeratedObjects

]

{ #category : 'Testing' }
EnumeratedPathEvaluator >> hasEnumeratedTerm [
  "Returns true if the path has a term that indicates an enumerated path term."

  ^ true

]

{ #category : 'Testing' }
EnumeratedPathEvaluator >> isIndexOnNscElements [
  "Returns whether the receiver is a path directly on the elements of an NSC
 (either the root NSC or an enumerated instance variable along the path)."

  ^ (self at: self size) includes: $|

]

{ #category : 'Traversing' }
EnumeratedPathEvaluator >> traverse: anObject startingAt: offset do: aBlock [
  "Traverse the sub-objects of anObject, using the path names of the receiver
 starting at the path name at the given offset.  For each object at the end of
 the traversal, evaluate the given block."

  | nextObj ivOffset pathName nscOffset sz |
  (nil == anObject _and: [ self isIndexOnNscElements not ])
    ifTrue: [ ^ self ].
  nextObj := anObject.
  sz := self size.
  offset to: sz do: [ :i |
    pathName := self at: i.
    (pathName includes: $|)
      ifTrue: [
        nscOffset := i + 1.
        (self enumeratedObjectsFor: nextObj pathTerm: pathName at: nscOffset)
          do: [ :obj | self traverse: obj startingAt: nscOffset do: aBlock ].
        ^ self ]
      ifFalse: [
        nil == nextObj
          ifTrue: [ ^ self ].
        ivOffset := nextObj class _idxIvOffsetOf: pathName.
        ivOffset == nil
          ifTrue: [ nextObj := nil ]
          ifFalse: [ nextObj := nextObj instVarAt: ivOffset ] ].
    (nil == nextObj _and: [ i ~= sz ])
      ifTrue: [ ^ self ] ].
  ^ aBlock value: nextObj

]

{ #category : 'Traversing' }
EnumeratedPathEvaluator >> traverse: anObject startingAt: offset into: resultSet [
  "Traverse the sub-objects of all the objects in the NSC, using the path names
 of the receiver starting at the path term at the given offset.  Add each
 object at the end of the traversal to the result set.  Returns the result
 set."

  | nextObj ivOffset pathName nscOffset sz |
  (nil == anObject _and: [ self isIndexOnNscElements not ])
    ifTrue: [ ^ resultSet ].
  nextObj := anObject.
  sz := self size.
  offset to: sz do: [ :i |
    pathName := self at: i.
    (pathName includes: $|)
      ifTrue: [
        nscOffset := i + 1.
        (self enumeratedObjectsFor: nextObj pathTerm: pathName at: nscOffset)
          do: [ :obj | self traverse: obj startingAt: nscOffset into: resultSet ].
        ^ resultSet ]
      ifFalse: [
        nil == nextObj
          ifTrue: [ ^ resultSet ].
        ivOffset := nextObj class _idxIvOffsetOf: pathName.
        ivOffset == nil
          ifTrue: [
            nextObj _errorInvalidOffset: pathName.
            nextObj := nil ]
          ifFalse: [ nextObj := nextObj instVarAt: ivOffset ] ].
    (nil == nextObj _and: [ i ~= sz ])
      ifTrue: [ ^ resultSet ] ].
  resultSet add: nextObj.
  ^ resultSet

]
